/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.chunkloaders;

import com.google.common.collect.ListMultimap;
import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.environmentaltech.EnvironmentalTech;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ChunkLoaderManager
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private static ChunkLoaderManager instance;
    private final Map<World, List<ForgeChunkManager.Ticket>> tickets = new IdentityHashMap<World, List<ForgeChunkManager.Ticket>>();
    private boolean dirty = false;

    public static ChunkLoaderManager getInstance() {
        if (instance == null) {
            instance = new ChunkLoaderManager();
        }
        return instance;
    }

    private ChunkLoaderManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)EnvironmentalTech.instance, (ForgeChunkManager.LoadingCallback)this);
        this.dirty = true;
    }

    private List<ForgeChunkManager.Ticket> getWorldTickets(World world) {
        if (world.field_72995_K) {
            return null;
        }
        if (!this.tickets.containsKey(world)) {
            this.tickets.put(world, new ArrayList());
        }
        return this.tickets.get(world);
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (this.dirty) {
            this.reloadChunkLoaders();
        }
    }

    public void reloadChunkLoaders() {
    }

    @SubscribeEvent
    public void unloadWorldEvent(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (this.tickets.containsKey(event.getWorld())) {
            this.tickets.remove(event.getWorld());
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        List<ForgeChunkManager.Ticket> worldTickets = this.getWorldTickets(world);
        for (ForgeChunkManager.Ticket ticket : tickets) {
            worldTickets.add(ticket);
            NBTTagList list = ticket.getModData().func_150295_c("chunks", 4);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagLong value = (NBTTagLong)list.func_179238_g(i);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)ChunkLoaderManager.deserialize(value.func_150291_c()));
            }
            ChunkPos chunk = ChunkLoaderManager.getChunkCoords(this.getPosFromTicket(ticket));
            if (ticket.getChunkList().contains((Object)chunk)) continue;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
        }
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return tickets;
    }

    public ForgeChunkManager.Ticket getTicket(World world, GameProfile player, BlockPos pos, boolean create) {
        if (world.field_72995_K) {
            return null;
        }
        List<ForgeChunkManager.Ticket> ticketList = this.getWorldTickets(world);
        if (ticketList == null) {
            throw new IllegalStateException();
        }
        for (ForgeChunkManager.Ticket ticket : ticketList) {
            if (!pos.equals((Object)this.getPosFromTicket(ticket))) continue;
            return ticket;
        }
        if (create) {
            return this.createTicket(world, player, pos);
        }
        return null;
    }

    public ForgeChunkManager.Ticket createTicket(World world, GameProfile player, BlockPos pos) {
        assert (this.getTicket(world, player, pos, false) == null);
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)EnvironmentalTech.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            return null;
        }
        ticket.getModData().func_74768_a("x", pos.func_177958_n());
        ticket.getModData().func_74768_a("y", pos.func_177956_o());
        ticket.getModData().func_74768_a("z", pos.func_177952_p());
        this.getWorldTickets(world).add(ticket);
        this.addToTicket(ticket, ChunkLoaderManager.getChunkCoords(pos));
        return ticket;
    }

    public void addToTicket(ForgeChunkManager.Ticket ticket, ChunkPos chunk) {
        if (ticket.getChunkList().contains((Object)chunk)) {
            return;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
        ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)ChunkLoaderManager.getChunkCoords(this.getPosFromTicket(ticket)));
        NBTTagList list = ticket.getModData().func_150295_c("chunks", 4);
        if (!ticket.getModData().func_150297_b("chunks", 9)) {
            ticket.getModData().func_74782_a("chunks", (NBTBase)list);
        }
        ticket.getModData().func_74782_a("chunks", (NBTBase)list);
        list.func_74742_a((NBTBase)new NBTTagLong((long)(chunk.field_77276_a & 0xFFFFFFFF | (chunk.field_77275_b & 0xFFFFFFFF) << 32)));
    }

    public void removeFromTicket(ForgeChunkManager.Ticket ticket, ChunkPos chunk) {
        if (ChunkLoaderManager.getChunkCoords(this.getPosFromTicket(ticket)).equals((Object)chunk)) {
            return;
        }
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
        NBTTagList list = ticket.getModData().func_150295_c("chunks", 4);
        long serializedChunk = ChunkLoaderManager.serialize(chunk);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagLong pos = (NBTTagLong)list.func_179238_g(i);
            if (pos.func_150291_c() != serializedChunk) continue;
            list.func_74744_a(i--);
        }
    }

    public void removeTicket(ForgeChunkManager.Ticket ticket) {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        this.getWorldTickets(ticket.world).remove(ticket);
    }

    private BlockPos getPosFromTicket(ForgeChunkManager.Ticket ticket) {
        return new BlockPos(ticket.getModData().func_74762_e("x"), ticket.getModData().func_74762_e("y"), ticket.getModData().func_74762_e("z"));
    }

    public static long serialize(ChunkPos chunk) {
        return chunk.field_77276_a & 0xFFFFFFFF | (chunk.field_77275_b & 0xFFFFFFFF) << 32;
    }

    public static ChunkPos deserialize(long value) {
        return new ChunkPos((int)(value & 0xFFFFFFFFFFFFFFFFL), (int)(value >> 32));
    }

    public static ChunkPos getChunkCoords(BlockPos pos) {
        return new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }
}

