/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.chunkloaders;

import cofh.api.energy.IEnergyReceiver;
import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.environmentaltech.tileentity.chunkloaders.ChunkLoaderManager;
import com.valkyrieofnight.valkyrielib.energy.compat.EnergyStorage;
import com.valkyrieofnight.valkyrielib.tileentity.VLTileEntity;
import com.valkyrieofnight.valkyrielib.util.helpers.PlayerUtil;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TileChunkLoaderBasic
extends VLTileEntity
implements ITickable,
IEnergyReceiver {
    private EnergyStorage eBuffer = new EnergyStorage(100000);
    private ForgeChunkManager.Ticket ticket;
    private GameProfile owner;
    private ChunkPos loaded;
    private static final int cost = 40;
    private boolean isLoaded = false;
    private int tick = 0;
    private boolean dirty = true;

    public TileChunkLoaderBasic() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.eBuffer.getEnergyStored() >= 0) {
                if (!this.getLoading()) {
                    this.setLoading(true);
                }
                this.eBuffer.extractEnergy(0, false);
            } else {
                this.setLoading(false);
            }
        }
    }

    public void setLoading(boolean opt) {
        if (!this.field_145850_b.field_72995_K && this.getLoading() != opt) {
            if (opt) {
                ForgeChunkManager.Ticket test;
                if (this.tick % 40 == 0 && this.ticket == null && (test = ChunkLoaderManager.getInstance().getTicket(this.field_145850_b, this.owner, this.field_174879_c, false)) == null) {
                    this.ticket = ChunkLoaderManager.getInstance().createTicket(this.field_145850_b, this.owner, this.func_174877_v());
                    if (this.ticket != null) {
                        ChunkLoaderManager.getInstance().addToTicket(this.ticket, this.loaded);
                        this.isLoaded = true;
                    }
                }
            } else if (this.ticket != null) {
                ChunkLoaderManager.getInstance().removeTicket(this.ticket);
                this.ticket = null;
                this.isLoaded = false;
            }
            ++this.tick;
            if (this.tick > 1000) {
                this.tick = 0;
            }
        }
    }

    public boolean getLoading() {
        return this.isLoaded;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void onLoad() {
        super.onLoad();
    }

    public void blockPlaced() {
        this.loaded = ChunkLoaderManager.getChunkCoords(this.field_174879_c);
    }

    public void blockBreak() {
        if (this.ticket != null) {
            ChunkLoaderManager.getInstance().removeTicket(this.ticket);
            this.ticket = null;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("loaded")) {
            long l = nbt.func_74763_f("loaded");
            this.loaded = ChunkLoaderManager.deserialize(l);
        }
        this.owner = PlayerUtil.profileFromNBT((NBTTagCompound)nbt.func_74775_l("profile"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("loaded", ChunkLoaderManager.serialize(this.loaded));
        if (this.owner != null) {
            nbt.func_74782_a("profile", (NBTBase)PlayerUtil.proifleToNBT((GameProfile)this.owner));
        }
        return nbt;
    }

    public void setPlayer(EntityPlayer plr) {
        if (plr != null) {
            this.owner = plr.func_146103_bH();
        }
    }

    public void setPlayer(UUID plr) {
        EntityPlayer pl = PlayerUtil.getPlayerFromWorld((World)this.field_145850_b, (UUID)plr);
        if (pl != null) {
            this.owner = pl.func_146103_bH();
        }
    }

    public UUID getPlayerID() {
        return this.owner.getId();
    }

    public GameProfile getPlayerProfile() {
        return this.owner;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.eBuffer.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.eBuffer.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.eBuffer.receiveEnergy(maxReceive, simulate);
    }
}

