/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.multiblock.voidminer;

import com.valkyrieofnight.environmentaltech.api.modifier.IModifierBlock;
import com.valkyrieofnight.environmentaltech.api.registry.IFocusableRegistry;
import com.valkyrieofnight.environmentaltech.api.util.WeightedStackBase;
import com.valkyrieofnight.environmentaltech.block.multiblock.voidoreminer.BlockLaserCore;
import com.valkyrieofnight.environmentaltech.block.multiblock.voidoreminer.ILaserLens;
import com.valkyrieofnight.environmentaltech.modifier.ModifierHandler;
import com.valkyrieofnight.environmentaltech.network.PacketDispatcher;
import com.valkyrieofnight.environmentaltech.network.packets.VoidMinerUpdatePacket;
import com.valkyrieofnight.valkyrielib.energy.EnergyReceiver;
import com.valkyrieofnight.valkyrielib.energy.IEnergyReceiver;
import com.valkyrieofnight.valkyrielib.energy.compat.ICOFHReceiver;
import com.valkyrieofnight.valkyrielib.inventory.CustomItemHandler;
import com.valkyrieofnight.valkyrielib.multiblock.VLTileController;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TileContVoidMinerBase
extends VLTileController
implements ICOFHReceiver,
IItemHandler {
    private EnergyReceiver eBuffer;
    private boolean canMine = false;
    private boolean canSeeVoid = false;
    private CustomItemHandler output;
    private List<BlockPos> modifiers;
    private BlockPos drillTip;
    private BlockPos laserLens;
    private ModifierHandler modifierHandler;
    private List<WeightedStackBase> possibleResults;
    private EnumDyeColor focusColor;
    private boolean colored;
    private Random rand;
    private int voidCheckTick = 0;
    private BlockPos voidBlock;
    private float focusBoostModifier = 1.0f;
    private boolean updateClients = false;

    public TileContVoidMinerBase(int rfInternal, int totalInternalStacks) {
        this.eBuffer = new EnergyReceiver(rfInternal);
        this.output = new CustomItemHandler(totalInternalStacks);
        this.modifiers = new ArrayList<BlockPos>();
        this.modifierHandler = new ModifierHandler();
        this.possibleResults = new ArrayList<WeightedStackBase>();
        this.rand = new Random();
        this.colored = false;
        this.focusColor = EnumDyeColor.WHITE;
    }

    public void func_73660_a() {
        super.func_73660_a();
        ++this.voidCheckTick;
        if (!this.field_145850_b.field_72995_K) {
            if (this.drillTip != null && this.laserLens != null) {
                this.canMine = true;
                this.updateClients = true;
                if (this.voidCheckTick % 80 == 0) {
                    this.voidBlock = this.canSeeVoidOrBedrock(this.drillTip);
                    this.canSeeVoid = this.voidBlock != null;
                    this.updateClients = true;
                }
            } else {
                this.canMine = false;
                this.updateClients = true;
                int lowestY = 255;
                for (BlockPos blockPos : this.getStructure().getSlavesOfType(BlockLaserCore.class, this.func_174877_v(), this.getMBDirectionE())) {
                    if (blockPos.func_177956_o() >= lowestY) continue;
                    lowestY = blockPos.func_177956_o();
                    this.drillTip = blockPos;
                }
                this.laserLens = (BlockPos)this.getStructure().getSlavesOfType(ILaserLens.class, this.func_174877_v(), this.getMBDirectionE()).get(0);
            }
            if (this.updateClients) {
                this.updateClients = false;
                PacketDispatcher.DISPATCHER.sendToAllAround((IMessage)new VoidMinerUpdatePacket(this), this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0);
            }
        } else {
            if (this.drillTip != null) {
                if (this.voidCheckTick % 80 == 0) {
                    this.voidBlock = this.canSeeVoidOrBedrock(this.drillTip);
                    this.canSeeVoid = this.voidBlock != null;
                }
            } else {
                int lowestY = 255;
                for (BlockPos blockPos : this.getStructure().getSlavesOfType(BlockLaserCore.class, this.func_174877_v(), this.getMBDirectionE())) {
                    if (blockPos.func_177956_o() >= lowestY) continue;
                    lowestY = blockPos.func_177956_o();
                    this.drillTip = blockPos;
                }
            }
            if (this.isFormed()) {
                this.laserLens = (BlockPos)this.getStructure().getSlavesOfType(ILaserLens.class, this.func_174877_v(), this.getMBDirectionE()).get(0);
                IBlockState lensBlock = this.field_145850_b.func_180495_p(this.laserLens);
                if (lensBlock.func_177230_c() instanceof ILaserLens) {
                    ILaserLens lens = (ILaserLens)lensBlock.func_177230_c();
                    if (lens.isColored()) {
                        this.focusColor = lens.getFocusColor(lensBlock);
                        this.colored = true;
                    } else {
                        this.focusColor = EnumDyeColor.WHITE;
                        this.colored = false;
                    }
                }
            }
        }
        if (this.voidCheckTick > 80000) {
            this.voidCheckTick = 0;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.eBuffer.writeToNBT(nbt);
        nbt.func_74782_a("outputs", (NBTBase)this.output.serializeNBT());
        nbt.func_74757_a("seevoid", this.canSeeVoid);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.eBuffer.readFromNBT(nbt);
        this.output.deserializeNBT(nbt.func_74775_l("outputs"));
        this.canSeeVoid = nbt.func_74767_n("seevoid");
    }

    public boolean canProcess() {
        IBlockState lensBlock;
        if (this.modifiers.isEmpty()) {
            this.modifiers = this.getStructure().getSlavesOfType(IModifierBlock.class, this.func_174877_v(), this.getMBDirectionE());
            ArrayList<IModifierBlock> mods = new ArrayList<IModifierBlock>();
            for (BlockPos mbp : this.modifiers) {
                Block blk = this.field_145850_b.func_180495_p(mbp).func_177230_c();
                if (!(blk instanceof IModifierBlock)) continue;
                mods.add((IModifierBlock)blk);
            }
            this.modifierHandler.setModifiers(mods);
            this.modifierHandler.calculateAttributeMultipliers();
            this.focusBoostModifier = this.modifierHandler.getAttributeMultiplier("accuracy");
        }
        if (this.possibleResults.isEmpty() && this.laserLens != null && (lensBlock = this.field_145850_b.func_180495_p(this.laserLens)).func_177230_c() instanceof ILaserLens) {
            ILaserLens lens = (ILaserLens)lensBlock.func_177230_c();
            if (lens.isColored()) {
                this.focusColor = lens.getFocusColor(lensBlock);
                this.possibleResults = this.getRegistry().getFocusedList(lens.getFocusColor(lensBlock), this.focusBoostModifier);
                this.colored = true;
            } else {
                this.possibleResults = this.getRegistry().getUnFocusedList();
                this.colored = false;
            }
        }
        if (this.output.getFreeSlots() < 1) {
            this.ejectAll((IItemHandler)this.output);
            return false;
        }
        if (this.eBuffer.getEnergyStored() < this.getEnergyCostPerTick()) {
            return false;
        }
        return this.canMine && this.canSeeVoid;
    }

    public void onProcessTick() {
        this.eBuffer.extractEnergyInternal(this.getEnergyCostPerTick(), false);
    }

    public abstract int getEnergyCostPerDuration();

    public abstract IFocusableRegistry getRegistry();

    public int getEnergyCostPerTick() {
        if (this.modifierHandler.hasAttribute("energycost")) {
            int e = (int)((float)this.getEnergyCostPerDuration() * this.modifierHandler.getAttributeMultiplier("energycost"));
            return e / this.getCurrentProcessDuration();
        }
        return this.getEnergyCostPerDuration() / this.getCurrentProcessDuration();
    }

    public void onProcessComplete() {
        WeightedStackBase result = (WeightedStackBase)WeightedRandom.func_76271_a((Random)this.rand, this.possibleResults);
        ItemStack cloneStack = result.getMainStack().func_77946_l();
        cloneStack.field_77994_a = 1;
        ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)cloneStack, (boolean)false);
        this.ejectAll((IItemHandler)this.output);
    }

    private BlockPos canSeeVoidOrBedrock(BlockPos pos) {
        for (int yy = pos.func_177956_o() - 1; yy > 0; --yy) {
            BlockPos bts = new BlockPos(pos.func_177958_n(), yy, pos.func_177952_p());
            IBlockState bs = this.field_145850_b.func_180495_p(bts);
            Block blk = bs.func_177230_c();
            if (blk == Blocks.field_150357_h) {
                return bts;
            }
            this.field_145850_b.func_175710_j(pos);
            if (blk == Blocks.field_150350_a || blk.getLightOpacity(bs, (IBlockAccess)this.field_145850_b, bts) <= 0 || bs.func_185904_a().func_76224_d()) continue;
            return null;
        }
        return new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
    }

    public float getSpeedMultiplier() {
        if (this.modifierHandler.hasAttribute("speed")) {
            return this.modifierHandler.getAttributeMultiplier("speed");
        }
        return 1.0f;
    }

    public void deformMultiblock() {
        super.deformMultiblock();
        this.modifiers = new ArrayList<BlockPos>();
        this.modifierHandler = new ModifierHandler();
        this.possibleResults = new ArrayList<WeightedStackBase>();
    }

    public void packetUpdate(boolean canMine, boolean canSeeVoid, int energyLevel, boolean clearLens) {
        this.canMine = canMine;
        this.canSeeVoid = canSeeVoid;
        this.eBuffer.setEnergyStored(energyLevel);
        this.colored = !clearLens;
    }

    public boolean getCanMine() {
        return this.canMine;
    }

    public boolean canSeeVoid() {
        return this.canSeeVoid;
    }

    public BlockPos getVoidPos() {
        return this.voidBlock;
    }

    public boolean isLensColored() {
        return this.colored;
    }

    public EnumDyeColor getLensColor() {
        return this.focusColor;
    }

    public IEnergyReceiver getEnergyReceiver() {
        return this.eBuffer;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.output;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.eBuffer;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getSlots() {
        return this.output.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.output.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.output.extractItem(slot, amount, simulate);
    }
}

