/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.api.blocks.IConnectedBlock;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;

public abstract class ConnectedTile
extends SonarMachineBlock
implements IConnectedBlock {
    public int target = 0;
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");

    protected ConnectedTile(int target) {
        super(SonarMaterials.machine, false, true);
        this.target = target;
    }

    public boolean checkBlockInDirection(IBlockAccess world, int x, int y, int z, EnumFacing side) {
        EnumFacing dir = side;
        IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
        IBlockState block = world.func_180495_p(new BlockPos(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e()));
        int meta = state.func_177230_c().func_176201_c(state);
        return block != null && ConnectedTile.type(state, block, meta, block.func_177230_c().func_176201_c(block));
    }

    public static boolean type(IBlockState state1, IBlockState state2, int m1, int m2) {
        Block block1 = state1.func_177230_c();
        Block block2 = state2.func_177230_c();
        if (!(block1 instanceof IConnectedBlock && block2 instanceof IConnectedBlock && m1 != m2 || !(block1 instanceof IConnectedBlock))) {
            IConnectedBlock c1 = (IConnectedBlock)block1;
            int[] connections1 = ((IConnectedBlock)block1).getConnections();
            if (block2 instanceof IConnectedBlock) {
                int[] connections2 = ((IConnectedBlock)block2).getConnections();
                for (int i = 0; i < connections1.length; ++i) {
                    for (int i2 = 0; i2 < connections2.length; ++i2) {
                        if (connections1[i] != connections2[i2]) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        super.func_149666_a(item, tab, list);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess w, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.EAST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.DOWN)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, DOWN, UP});
    }

    @Override
    public int[] getConnections() {
        return new int[]{this.target};
    }
}

