/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.IMachineSides;
import sonar.core.utils.MachineSideConfig;
import sonar.core.utils.MachineSides;

public abstract class SonarSidedBlock
extends SonarMachineBlock {
    public static final PropertyEnum<MachineSideConfig> NORTH = PropertyEnum.func_177706_a((String)"north", MachineSideConfig.class, (Enum[])new MachineSideConfig[]{MachineSideConfig.INPUT, MachineSideConfig.INPUT_ANIMATE, MachineSideConfig.OUTPUT, MachineSideConfig.OUTPUT_ANIMATE});
    public static final PropertyEnum<MachineSideConfig> NORTH_NO_ANIMATE = PropertyEnum.func_177706_a((String)"north", MachineSideConfig.class, (Enum[])new MachineSideConfig[]{MachineSideConfig.INPUT, MachineSideConfig.OUTPUT});
    public static final PropertyEnum<MachineSideConfig> EAST = PropertyEnum.func_177706_a((String)"east", MachineSideConfig.class, (Enum[])new MachineSideConfig[]{MachineSideConfig.INPUT, MachineSideConfig.OUTPUT});
    public static final PropertyEnum<MachineSideConfig> SOUTH = PropertyEnum.func_177706_a((String)"south", MachineSideConfig.class, (Enum[])new MachineSideConfig[]{MachineSideConfig.INPUT, MachineSideConfig.OUTPUT});
    public static final PropertyEnum<MachineSideConfig> WEST = PropertyEnum.func_177706_a((String)"west", MachineSideConfig.class, (Enum[])new MachineSideConfig[]{MachineSideConfig.INPUT, MachineSideConfig.OUTPUT});
    public static final PropertyEnum<MachineSideConfig> UP = PropertyEnum.func_177706_a((String)"up", MachineSideConfig.class, (Enum[])new MachineSideConfig[]{MachineSideConfig.INPUT, MachineSideConfig.OUTPUT});
    public static final PropertyEnum<MachineSideConfig> DOWN = PropertyEnum.func_177706_a((String)"down", MachineSideConfig.class, (Enum[])new MachineSideConfig[]{MachineSideConfig.INPUT, MachineSideConfig.OUTPUT});

    protected SonarSidedBlock(Material material, boolean orientation, boolean wrenchable) {
        super(material, orientation, wrenchable);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(this.hasAnimatedFront() ? NORTH : NORTH_NO_ANIMATE, (Comparable)((Object)MachineSideConfig.INPUT)).func_177226_a(EAST, (Comparable)((Object)MachineSideConfig.INPUT)).func_177226_a(SOUTH, (Comparable)((Object)MachineSideConfig.INPUT)).func_177226_a(WEST, (Comparable)((Object)MachineSideConfig.INPUT)).func_177226_a(UP, (Comparable)((Object)MachineSideConfig.INPUT)).func_177226_a(DOWN, (Comparable)((Object)MachineSideConfig.INPUT)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess w, BlockPos pos) {
        TileEntity target = w.func_175625_s(pos);
        if (target != null && target instanceof IMachineSides) {
            MachineSides sides = ((IMachineSides)target).getSideConfigs();
            EnumFacing front = (EnumFacing)state.func_177229_b((IProperty)FACING);
            MachineSideConfig frontConfig = sides.getSideConfig(SonarHelper.offsetFacing(EnumFacing.NORTH, front));
            return state.func_177226_a(this.hasAnimatedFront() ? NORTH : NORTH_NO_ANIMATE, (Comparable)((Object)(this.hasAnimatedFront() && this.isAnimated(state, w, pos) ? frontConfig.getAnimated() : frontConfig))).func_177226_a(SOUTH, (Comparable)((Object)sides.getSideConfig(SonarHelper.offsetFacing(EnumFacing.SOUTH, front)))).func_177226_a(WEST, (Comparable)((Object)sides.getSideConfig(SonarHelper.offsetFacing(EnumFacing.WEST, front)))).func_177226_a(EAST, (Comparable)((Object)sides.getSideConfig(SonarHelper.offsetFacing(EnumFacing.EAST, front)))).func_177226_a(UP, (Comparable)((Object)sides.getSideConfig(EnumFacing.UP))).func_177226_a(DOWN, (Comparable)((Object)sides.getSideConfig(EnumFacing.DOWN)));
        }
        return state;
    }

    public boolean hasAnimatedFront() {
        return true;
    }

    public boolean isAnimated(IBlockState state, IBlockAccess w, BlockPos pos) {
        return true;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, this.hasAnimatedFront() ? NORTH : NORTH_NO_ANIMATE, EAST, SOUTH, WEST, UP, DOWN});
    }
}

