/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.item;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import sonar.core.common.item.InventoryContainerItem;

public class InventoryItem
implements IInventory {
    private String name = "Inventory Item";
    private final ItemStack invItem;
    private ItemStack[] inventory;
    private static String invTag = "inv";
    private String tag;
    private boolean useStackTag;
    public int size;

    public InventoryItem(ItemStack stack, int size, String tag, boolean useStackTag) {
        this.inventory = new ItemStack[size];
        this.invItem = stack;
        this.tag = tag;
        this.useStackTag = useStackTag;
        if (useStackTag) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            this.readFromNBT(stack.func_77978_p());
        } else {
            this.readFromNBT(stack.func_179543_a(tag, true));
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.func_70299_a(slot, null);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.setInventorySlotContents(slot, stack, false);
    }

    public void setInventorySlotContents(int slot, ItemStack stack, boolean isRemote) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (!isRemote) {
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.name, new Object[0]);
    }

    public boolean hasCustomInventoryName() {
        return this.name.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77994_a != 0) continue;
            this.inventory[i] = null;
        }
        if (this.useStackTag) {
            this.writeToNBT(this.invItem.func_77978_p());
        } else {
            this.writeToNBT(this.invItem.func_179543_a(this.tag, true));
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return !(itemstack.func_77973_b() instanceof InventoryContainerItem);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList items = compound.func_150295_c(invTag, 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList items = new NBTTagList();
        int size = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("Slot", i);
            this.func_70301_a(i).func_77955_b(item);
            items.func_74742_a((NBTBase)item);
            ++size;
        }
        compound.func_74782_a(invTag, (NBTBase)items);
        compound.func_74768_a("invsize", size);
    }

    public int getItemsStored(ItemStack stack) {
        if (this.useStackTag) {
            if (stack.func_77942_o()) {
                return stack.func_77978_p().func_74762_e(this.tag + "size");
            }
            return 0;
        }
        return stack.func_179543_a(this.tag, true).func_74762_e("invsize");
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
        }
    }
}

