/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tileentity;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import sonar.core.api.SonarAPI;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.energy.ISonarEnergyTile;
import sonar.core.api.utils.ActionType;
import sonar.core.common.tileentity.TileEntitySidedInventory;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.EUHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.network.sync.SyncEnergyStorage;

public class TileEntityEnergySidedInventory
extends TileEntitySidedInventory
implements IEnergyReceiver,
IEnergyProvider,
ISonarEnergyTile,
IEnergySource,
IEnergySink {
    public EnergyMode energyMode = EnergyMode.RECIEVE;
    public final SyncEnergyStorage storage = new SyncEnergyStorage(0);
    public int maxTransfer;

    public TileEntityEnergySidedInventory() {
        this.syncParts.add(this.storage);
    }

    public void setEnergyMode(EnergyMode mode) {
        this.energyMode = mode;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(NBTHelper.SyncType.DROP)) {
            this.storage.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(NBTHelper.SyncType.DROP)) {
            nbt.func_74768_a("energy", this.storage.getEnergyStored());
        }
        return nbt;
    }

    public void discharge(int id) {
        this.slots()[id] = SonarAPI.getEnergyHelper().dischargeItem(this.slots()[id], this, this.maxTransfer != 0 ? Math.min((long)this.maxTransfer, this.getStorage().getMaxExtract()) : this.getStorage().getMaxExtract());
    }

    public void charge(int id) {
        this.slots()[id] = SonarAPI.getEnergyHelper().chargeItem(this.slots()[id], this, this.maxTransfer != 0 ? Math.min((long)this.maxTransfer, this.getStorage().getMaxExtract()) : this.getStorage().getMaxExtract());
    }

    public void addEnergy(EnumFacing ... faces) {
        for (EnumFacing dir : faces) {
            TileEntity entity = SonarHelper.getAdjacentTileEntity(this, dir);
            SonarAPI.getEnergyHelper().transferEnergy(this, entity, dir.func_176734_d(), dir, this.maxTransfer);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        EnergyMode mode = this.getModeForSide(facing);
        if (SonarLoader.teslaLoaded && mode.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && mode.canRecieve() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && mode.canSend() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        EnergyMode mode = this.getModeForSide(facing);
        if (SonarLoader.teslaLoaded && mode.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && mode.canRecieve() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && mode.canSend() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return (T)this.storage;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public EnergyMode getModeForSide(EnumFacing side) {
        if (side == null) {
            return EnergyMode.SEND_RECIEVE;
        }
        return this.energyMode;
    }

    @Override
    public SyncEnergyStorage getStorage() {
        return this.storage;
    }

    @Override
    public EnergyMode getMode() {
        return this.energyMode;
    }

    @Override
    public final boolean canConnectEnergy(EnumFacing from) {
        return this.getModeForSide(from).canConnect();
    }

    @Override
    public final int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public final int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public final int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.getModeForSide(from).canSend() ? this.storage.extractEnergy(maxExtract, simulate) : 0;
    }

    @Override
    public final int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.getModeForSide(from).canRecieve() ? this.storage.receiveEnergy(maxReceive, simulate) : 0;
    }

    @Override
    public void onFirstTick() {
        super.onFirstTick();
        if (!this.field_145850_b.field_72995_K && SonarLoader.ic2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && SonarLoader.ic2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    @Override
    public double getDemandedEnergy() {
        return Math.min(EUHelper.getVoltage(this.getSinkTier()), (double)(this.storage.addEnergy(this.storage.getMaxReceive(), ActionType.getTypeForAction(true)) / 4L));
    }

    @Override
    public int getSinkTier() {
        return 4;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.getModeForSide(side).canRecieve();
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        int addRF = this.storage.receiveEnergy((int)amount * 4, true);
        this.storage.addEnergy(addRF, ActionType.getTypeForAction(false));
        return amount - (double)(addRF / 4);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.getModeForSide(side).canSend();
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(EUHelper.getVoltage(this.getSourceTier()), (double)(this.storage.removeEnergy(this.maxTransfer, ActionType.getTypeForAction(true)) / 4L));
    }

    @Override
    public void drawEnergy(double amount) {
        this.storage.removeEnergy((long)(amount * 4.0), ActionType.getTypeForAction(false));
    }

    @Override
    public int getSourceTier() {
        return 4;
    }
}

