/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.IWailaInfo;
import sonar.core.network.PacketRequestSync;
import sonar.core.network.PacketTileSync;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.utils.IWorldPosition;

public class TileEntitySonar
extends TileEntity
implements ITickable,
INBTSyncable,
IWailaInfo,
IWorldPosition {
    public ArrayList<ISyncPart> syncParts = new ArrayList();
    public ArrayList<IDirtyPart> dirtyParts = new ArrayList();
    protected boolean forceSync;
    protected BlockCoords coords = BlockCoords.EMPTY;
    public boolean loaded = true;
    protected DirtyPart isDirty = new DirtyPart();

    public boolean isClient() {
        return this.field_145850_b == null ? false : this.field_145850_b.field_72995_K;
    }

    public boolean isServer() {
        return this.field_145850_b == null ? true : !this.field_145850_b.field_72995_K;
    }

    public final void onLoad() {
        this.isDirty.setChanged(true);
    }

    public void onFirstTick() {
        this.markBlockForUpdate();
    }

    public void func_73660_a() {
        boolean markDirty = false;
        if (this.loaded) {
            this.onFirstTick();
            this.loaded = !this.loaded;
        }
        for (ISyncPart iSyncPart : this.syncParts) {
            if (iSyncPart == null || !iSyncPart.hasChanged()) continue;
            markDirty = true;
            break;
        }
        for (IDirtyPart iDirtyPart : this.dirtyParts) {
            if (iDirtyPart == null || !iDirtyPart.hasChanged()) continue;
            markDirty = true;
            iDirtyPart.setChanged(false);
        }
        if (markDirty) {
            this.func_70296_d();
        }
    }

    @Override
    public BlockCoords getCoords() {
        return this.coords;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readData(nbt, NBTHelper.SyncType.SAVE);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeData(nbt, NBTHelper.SyncType.SAVE);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeData(super.func_189517_E_(), NBTHelper.SyncType.SYNC_OVERRIDE);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readData(tag, NBTHelper.SyncType.SYNC_OVERRIDE);
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.coords = new BlockCoords(this);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.readSyncParts(nbt, type, this.syncParts);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.forceSync && type == NBTHelper.SyncType.DEFAULT_SYNC) {
            type = NBTHelper.SyncType.SYNC_OVERRIDE;
            this.forceSync = false;
        }
        NBTHelper.writeSyncParts(nbt, type, this.syncParts, this.forceSync);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        return currenttip;
    }

    public void forceNextSync() {
        this.forceSync = true;
        this.isDirty.setChanged(true);
    }

    public void requestSyncPacket() {
        SonarCore.network.sendToServer((IMessage)new PacketRequestSync(this.field_174879_c));
    }

    public void sendSyncPacket(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (player != null && player instanceof EntityPlayerMP) {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeData(tag, NBTHelper.SyncType.SYNC_OVERRIDE);
            if (!tag.func_82582_d()) {
                SonarCore.network.sendTo((IMessage)new PacketTileSync(this.field_174879_c, tag), (EntityPlayerMP)player);
            }
        }
    }

    public void markBlockForUpdate() {
        if (this.isServer()) {
            this.isDirty.setChanged(true);
            SonarCore.sendFullSyncAroundWithRenderUpdate(this, 128);
        } else {
            this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
            this.func_145831_w().func_175726_f(this.func_174877_v()).func_76630_e();
        }
    }

    public boolean maxRender() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return this.maxRender() ? 65536.0 : super.func_145833_n();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.maxRender() ? INFINITE_EXTENT_AABB : super.getRenderBoundingBox();
    }
}

