/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import sonar.core.SonarCore;
import sonar.core.utils.Pair;

public class ASMLoader {
    public static void log(ASMLog log, Class type, ASMDataTable.ASMData asm, String modid) {
        switch (log) {
            case ERROR: {
                SonarCore.logger.error(type.getSimpleName() + " couldn't be loaded: {}", new Object[]{asm.getClassName()});
                break;
            }
            case LOADED: {
                SonarCore.logger.info(type.getSimpleName() + " loaded successfully: {}", new Object[]{asm.getClassName()});
                break;
            }
            case MODID: {
                SonarCore.logger.error(String.format("Couldn't load" + type.getSimpleName() + "%s for modid %s", asm.getClassName(), modid));
                break;
            }
        }
    }

    public static <T> List<T> getInstances(@Nonnull ASMDataTable asmDataTable, Class annotation, Class<T> instanceClass, boolean checkModid) {
        String annotationClassName = annotation.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            String modid;
            String string = modid = checkModid ? (String)asmData.getAnnotationInfo().get("modid") : "";
            if (!checkModid || Loader.isModLoaded((String)modid)) {
                try {
                    Class<?> asmClass = Class.forName(asmData.getClassName());
                    Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                    T instance = asmInstanceClass.newInstance();
                    instances.add(instance);
                    ASMLoader.log(ASMLog.LOADED, instanceClass, asmData, modid);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    ASMLoader.log(ASMLog.ERROR, instanceClass, asmData, modid);
                }
                continue;
            }
            ASMLoader.log(ASMLog.MODID, instanceClass, asmData, modid);
        }
        return instances;
    }

    public static <T> List<Pair<ASMDataTable.ASMData, Class<? extends T>>> getClasses(@Nonnull ASMDataTable asmDataTable, Class annotation, Class<T> instanceClass, boolean checkModid) {
        String annotationClassName = annotation.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<Pair<ASMDataTable.ASMData, Class<T>>> classes = new ArrayList<Pair<ASMDataTable.ASMData, Class<T>>>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            String modid;
            String string = modid = checkModid ? (String)asmData.getAnnotationInfo().get("modid") : "";
            if (!checkModid || Loader.isModLoaded((String)modid)) {
                try {
                    Class<?> asmClass = Class.forName(asmData.getClassName());
                    Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                    classes.add(new Pair<ASMDataTable.ASMData, Class<T>>(asmData, asmInstanceClass));
                    ASMLoader.log(ASMLog.LOADED, instanceClass, asmData, modid);
                }
                catch (ClassNotFoundException e) {
                    ASMLoader.log(ASMLog.ERROR, instanceClass, asmData, modid);
                }
                continue;
            }
            ASMLoader.log(ASMLog.MODID, instanceClass, asmData, modid);
        }
        return classes;
    }

    public static enum ASMLog {
        LOADED,
        ERROR,
        MODID;

    }
}

