/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import sonar.core.SonarCore;
import sonar.core.api.StorageSize;
import sonar.core.api.inventories.InventoryHandler;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;
import sonar.core.api.wrappers.InventoryWrapper;

public class InventoryHelper
extends InventoryWrapper {
    @Override
    public StoredItemStack getStackToAdd(long inputSize, StoredItemStack stack, StoredItemStack returned) {
        StoredItemStack simulateStack = null;
        simulateStack = returned == null || returned.stored == 0L ? new StoredItemStack(stack.getItemStack(), inputSize) : new StoredItemStack(stack.getItemStack(), inputSize - returned.stored);
        return simulateStack;
    }

    @Override
    public StorageSize addInventoryToList(List<StoredItemStack> list, IInventory inv) {
        long stored = 0L;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            stored += (long)stack.field_77994_a;
            this.addStackToList(list, inv.func_70301_a(i));
        }
        int max = inv.func_70297_j_() * inv.func_70302_i_();
        return new StorageSize(stored, max);
    }

    @Override
    public StorageSize addItemHandlerToList(List<StoredItemStack> list, IItemHandler inv) {
        long stored = 0L;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) continue;
            stored += (long)stack.field_77994_a;
            this.addStackToList(list, inv.getStackInSlot(i));
        }
        return new StorageSize(stored, inv.getSlots() * 64);
    }

    private void addStackToList(List<StoredItemStack> list, ItemStack stack) {
        int pos = 0;
        for (StoredItemStack storedStack : list) {
            if (storedStack.equalStack(stack)) {
                list.get(pos).add(stack);
                return;
            }
            ++pos;
        }
        list.add(new StoredItemStack(stack));
    }

    @Override
    public void addStackToList(List<StoredItemStack> list, StoredItemStack stack) {
        if (stack == null || list == null) {
            return;
        }
        int pos = 0;
        for (StoredItemStack storedStack : list) {
            if (storedStack.equalStack(stack.item)) {
                list.get(pos).add(stack);
                return;
            }
            ++pos;
        }
        list.add(stack);
    }

    @Override
    public void spawnStoredItemStack(StoredItemStack drop, World world, int x, int y, int z, EnumFacing side) {
        ArrayList<EntityItem> drops = new ArrayList<EntityItem>();
        while (drop.stored > 0L) {
            ItemStack dropStack = drop.getItemStack();
            dropStack.field_77994_a = (int)Math.min(drop.stored, (long)dropStack.func_77976_d());
            drop.stored -= (long)dropStack.field_77994_a;
            drops.add(new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, dropStack));
        }
        if (drop.stored < 0L) {
            SonarCore.logger.error("ERROR: Excess Items in Drop");
        }
        for (EntityItem item : drops) {
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            if (side == EnumFacing.NORTH) {
                item.field_70179_y = -0.1;
            }
            if (side == EnumFacing.SOUTH) {
                item.field_70179_y = 0.1;
            }
            if (side == EnumFacing.WEST) {
                item.field_70159_w = -0.1;
            }
            if (side == EnumFacing.EAST) {
                item.field_70159_w = 0.1;
            }
            world.func_72838_d((Entity)item);
        }
    }

    @Override
    public StoredItemStack addItems(TileEntity tile, StoredItemStack stack, EnumFacing dir, ActionType type, IInventoryFilter filter) {
        if (stack == null) {
            return null;
        }
        if (tile != null && (filter == null || filter.allowed(stack.getFullStack()))) {
            List handlers = SonarCore.inventoryProviders.getObjects();
            for (InventoryHandler handler : handlers) {
                if (!handler.canHandleItems(tile, dir)) continue;
                StoredItemStack returned = handler.addStack(stack.copy(), tile, dir, type);
                StoredItemStack add = this.getStackToAdd(stack.getStackSize(), stack.copy(), returned);
                return add;
            }
        }
        return null;
    }

    @Override
    public StoredItemStack removeItems(TileEntity tile, StoredItemStack stack, EnumFacing dir, ActionType type, IInventoryFilter filter) {
        if (tile != null && filter == null || filter.allowed(stack.getFullStack())) {
            List handlers = SonarCore.inventoryProviders.getObjects();
            for (InventoryHandler handler : handlers) {
                if (!handler.canHandleItems(tile, dir)) continue;
                StoredItemStack returned = handler.removeStack(stack.copy(), tile, dir, type);
                StoredItemStack remove = this.getStackToAdd(stack.getStackSize(), stack.copy(), returned);
                return remove;
            }
        }
        return null;
    }

    @Override
    public void transferItems(TileEntity from, TileEntity to, EnumFacing dirFrom, EnumFacing dirTo, IInventoryFilter filter) {
        if (from != null && to != null) {
            ArrayList<StoredItemStack> stacks = new ArrayList<StoredItemStack>();
            List handlers = SonarCore.inventoryProviders.getObjects();
            for (InventoryHandler handler : handlers) {
                if (!handler.canHandleItems(from, dirFrom)) continue;
                handler.getItems(stacks, from, dirFrom);
                break;
            }
            if (stacks.isEmpty()) {
                return;
            }
            for (StoredItemStack stack : stacks) {
                StoredItemStack add;
                StoredItemStack removed = this.removeItems(from, stack.copy(), dirFrom, ActionType.SIMULATE, filter);
                if (removed == null || (add = this.addItems(to, removed.copy(), dirTo, ActionType.SIMULATE, filter)) == null) continue;
                this.removeItems(from, add.copy(), dirFrom, ActionType.PERFORM, filter);
                this.addItems(to, removed.copy(), dirTo, ActionType.PERFORM, filter);
            }
        }
    }

    public static interface IInventoryFilter {
        public boolean allowed(ItemStack var1);
    }
}

