/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import sonar.core.api.utils.BlockCoords;
import sonar.core.integration.SonarLoader;

public class SonarHelper {
    public static TileEntity getAdjacentTileEntity(TileEntity tile, EnumFacing side) {
        return tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(side));
    }

    public static Block getAdjacentBlock(World world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos.func_177972_a(side)).func_177230_c();
    }

    public static void dropTile(EntityPlayer player, Block block, World world, BlockPos pos) {
        ItemStack stack = player.func_184614_ca();
        TileEntity te = world.func_175625_s(pos);
        if (SonarLoader.calculatorLoaded() && block == GameRegistry.findBlock((String)"Calculator", (String)"ConductorMastBlock")) {
            if (world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 1)).func_177230_c() == GameRegistry.findBlock((String)"Calculator", (String)"ConductorMast")) {
                block.func_180657_a(world, player, pos.func_177967_a(EnumFacing.DOWN, 1), world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 1)), te, stack);
            } else if (world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 2)).func_177230_c() == GameRegistry.findBlock((String)"Calculator", (String)"ConductorMast")) {
                block.func_180657_a(world, player, pos.func_177967_a(EnumFacing.DOWN, 2), world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 3)), te, stack);
            } else if (world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 3)).func_177230_c() == GameRegistry.findBlock((String)"Calculator", (String)"ConductorMast")) {
                block.func_180657_a(world, player, pos.func_177967_a(EnumFacing.DOWN, 3), world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 3)), te, stack);
            }
        } else {
            block.func_180657_a(world, player, pos, world.func_180495_p(pos), te, stack);
        }
    }

    public static Entity getNearestEntity(Class entityClass, TileEntity tile, int range) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)(tile.func_174877_v().func_177958_n() - range), (double)(tile.func_174877_v().func_177956_o() - range), (double)(tile.func_174877_v().func_177952_p() - range), (double)(tile.func_174877_v().func_177958_n() + range), (double)(tile.func_174877_v().func_177956_o() + range), (double)(tile.func_174877_v().func_177952_p() + range));
        List entities = tile.func_145831_w().func_72872_a(entityClass, aabb);
        Entity entity = null;
        double closest = Double.MAX_VALUE;
        for (int i = 0; i < entities.size(); ++i) {
            double d2;
            double d1;
            Entity target = (Entity)entities.get(i);
            double d0 = (double)tile.func_174877_v().func_177958_n() - target.field_70165_t;
            double distance = d0 * d0 + (d1 = (double)tile.func_174877_v().func_177956_o() - target.field_70163_u) * d1 + (d2 = (double)tile.func_174877_v().func_177952_p() - target.field_70161_v) * d2;
            if (!(distance < closest)) continue;
            entity = target;
            closest = distance;
        }
        return entity;
    }

    public static EntityPlayerMP getPlayerFromName(String player) {
        List server = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_184103_al().func_181057_v();
        for (EntityPlayerMP entityPlayer : server) {
            if (!entityPlayer.func_70005_c_().equals(player)) continue;
            return entityPlayer;
        }
        return null;
    }

    public static EntityPlayer getPlayerFromUUID(UUID player) {
        EntityPlayer fromUUID = null;
        Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(player);
        if (entity instanceof EntityPlayer) {
            fromUUID = (EntityPlayer)entity;
        }
        return fromUUID;
    }

    public static GameProfile getProfileByUUID(UUID playerUUID) {
        if (playerUUID == null) {
            return new GameProfile(UUID.randomUUID(), "ERROR: UUID IS INCORRECT");
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(playerUUID);
        }
        return new GameProfile(playerUUID, UsernameCache.containsUUID((UUID)playerUUID) ? UsernameCache.getLastKnownUsername((UUID)playerUUID) : "PLAYER ERROR!");
    }

    public static GameProfile getGameProfileForUsername(String playerName) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(playerName);
    }

    public static EnumFacing getForward(int meta) {
        return EnumFacing.func_82600_a((int)meta).func_176735_f();
    }

    public static int getAngleFromMeta(int meta) {
        switch (meta) {
            case 2: {
                return 180;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 90;
            }
            case 5: {
                return 270;
            }
        }
        return 0;
    }

    public static int invertMetadata(int meta) {
        switch (meta) {
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public static ItemStack createStackedBlock(Block block, int meta) {
        if (block == null) {
            return null;
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            return null;
        }
        int j = 0;
        if (item.func_77614_k()) {
            j = meta;
        }
        return new ItemStack(item, 1, j);
    }

    public static EnumFacing offsetFacing(EnumFacing facing, EnumFacing front) {
        if (facing.func_176740_k().func_176716_d() == EnumFacing.Plane.VERTICAL || front.func_176740_k().func_176716_d() == EnumFacing.Plane.VERTICAL) {
            return facing;
        }
        return EnumFacing.func_176733_a((double)(SonarHelper.getRenderRotation(front) + SonarHelper.getRenderRotation(facing))).func_176734_d();
    }

    public static int getRenderRotation(EnumFacing face) {
        switch (face) {
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 270;
            }
            case EAST: {
                return 90;
            }
        }
        return 0;
    }

    public static EnumFacing getHorizontal(EnumFacing dir) {
        if (dir == EnumFacing.NORTH) {
            return EnumFacing.EAST;
        }
        if (dir == EnumFacing.EAST) {
            return EnumFacing.SOUTH;
        }
        if (dir == EnumFacing.SOUTH) {
            return EnumFacing.WEST;
        }
        if (dir == EnumFacing.WEST) {
            return EnumFacing.NORTH;
        }
        return null;
    }

    public static ArrayList<BlockCoords> getConnectedBlocks(Block block, List<EnumFacing> dirs, World w, BlockPos pos, int max) {
        ArrayList<BlockCoords> handlers = new ArrayList<BlockCoords>();
        SonarHelper.addCoords(block, w, pos, max, handlers, dirs);
        return handlers;
    }

    public static void addCoords(Block block, World w, BlockPos pos, int max, ArrayList<BlockCoords> handlers, List<EnumFacing> dirs) {
        for (EnumFacing side : dirs) {
            BlockCoords coords;
            Block tile;
            if (handlers.size() > max) {
                return;
            }
            BlockPos current = pos.func_177972_a(side);
            IBlockState state = w.func_180495_p(current);
            if (state == null || (tile = w.func_180495_p(current).func_177230_c()) != block || handlers.contains(coords = new BlockCoords(current))) continue;
            handlers.add(coords);
            SonarHelper.addCoords(block, w, current, max, handlers, dirs);
        }
    }

    public static <E extends Enum> E incrementEnum(E enumObj, E[] values) {
        int ordinal = enumObj.ordinal() + 1;
        if (ordinal < values.length) {
            return values[ordinal];
        }
        return values[0];
    }
}

