/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.integration.SonarLoader;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.network.PacketFlexibleOpenGui;

public class FlexibleGuiHandler {
    public static String MULTIPART = "multipart";
    public static String TILEENTITY = "tile";
    public static String ITEM = "item";
    public static String ID = "id";
    public static String UUID = "uuid";

    public Object getServerElement(int id, EntityPlayer player, World world, BlockPos pos, NBTTagCompound tag) {
        TileEntity obj = null;
        if (SonarLoader.mcmultipartLoaded && tag.func_74767_n(MULTIPART)) {
            UUID uuid = tag.func_186857_a(UUID);
            obj = SonarMultipartHelper.getPart(uuid, world, pos);
        } else if (tag.func_74767_n(TILEENTITY)) {
            obj = world.func_175625_s(pos);
        } else if (tag.func_74767_n(ITEM)) {
            obj = player.func_184614_ca();
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof ItemStack && ((ItemStack)obj).func_77973_b() instanceof IFlexibleGui) {
            return ((IFlexibleGui)((ItemStack)obj).func_77973_b()).getServerElement(obj, id, world, player, tag);
        }
        if (obj instanceof IFlexibleGui) {
            return ((IFlexibleGui)obj).getServerElement(obj, id, world, player, tag);
        }
        return null;
    }

    public Object getClientElement(int id, EntityPlayer player, World world, BlockPos pos, NBTTagCompound tag) {
        TileEntity obj = null;
        if (SonarLoader.mcmultipartLoaded && tag.func_74767_n(MULTIPART)) {
            UUID uuid = tag.func_186857_a(UUID);
            obj = SonarMultipartHelper.getPart(uuid, world, pos);
        } else if (tag.func_74767_n(TILEENTITY)) {
            obj = world.func_175625_s(pos);
        } else if (tag.func_74767_n(ITEM)) {
            obj = player.func_184614_ca();
        }
        if (obj instanceof ItemStack && ((ItemStack)obj).func_77973_b() instanceof IFlexibleGui) {
            return ((IFlexibleGui)((ItemStack)obj).func_77973_b()).getClientElement(obj, id, world, player, tag);
        }
        if (obj instanceof IFlexibleGui) {
            return ((IFlexibleGui)obj).getClientElement(obj, id, world, player, tag);
        }
        return null;
    }

    public void openBasicTile(TileEntity tile, EntityPlayer player, World world, BlockPos pos, int id) {
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(TILEENTITY, true);
        this.openGui(player, world, pos, id, tag);
    }

    public void openBasicMultipart(UUID multipartUUID, EntityPlayer player, World world, BlockPos pos, int id) {
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(MULTIPART, true);
        tag.func_186854_a(UUID, multipartUUID);
        this.openGui(player, world, pos, id, tag);
    }

    public void openBasicItemStack(ItemStack stack, EntityPlayer player, World world, BlockPos pos, int id) {
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(ITEM, true);
        this.openGui(player, world, pos, id, tag);
    }

    public void openGui(EntityPlayer player, World world, BlockPos pos, int id, NBTTagCompound tag) {
        if (player instanceof EntityPlayerMP && !(player instanceof FakePlayer)) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
            Container container = (Container)this.getServerElement(id, player, world, pos, tag);
            if (container != null) {
                entityPlayerMP.func_71117_bO();
                entityPlayerMP.func_71128_l();
                int windowId = entityPlayerMP.field_71139_cq;
                tag.func_74768_a(ID, id);
                SonarCore.network.sendTo((IMessage)new PacketFlexibleOpenGui(pos, windowId, tag), (EntityPlayerMP)player);
                entityPlayerMP.field_71070_bA = container;
                entityPlayerMP.field_71070_bA.field_75152_c = windowId;
                entityPlayerMP.field_71070_bA.func_75132_a((IContainerListener)entityPlayerMP);
            }
        }
    }
}

