/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.IBufManager;
import sonar.core.api.nbt.IBufObject;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;

public class SyncGeneric<T extends IBufObject>
extends SyncPart {
    private T c;
    private IBufManager<T> manager;

    public SyncGeneric(IBufManager<T> manager, int id) {
        super(id);
        this.manager = manager;
    }

    public SyncGeneric(IBufManager<T> manager, String name) {
        super(name);
        this.manager = manager;
    }

    public void setDefault(T def) {
        this.c = def;
    }

    public void setObject(T value) {
        this.c = value;
        this.setChanged(true);
    }

    public T getObject() {
        return this.c;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        this.manager.writeToBuf(buf, this.c);
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.c = this.manager.readFromBuf(buf);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound infoTag = new NBTTagCompound();
        this.manager.writeToNBT(infoTag, this.c);
        if (!infoTag.func_82582_d()) {
            nbt.func_74782_a(this.getTagName(), (NBTBase)infoTag);
        }
        return nbt;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            this.c = (IBufObject)this.manager.readFromNBT(nbt.func_74775_l(this.getTagName()));
        }
    }

    public String toString() {
        return this.c.toString();
    }
}

