/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sonar.core.integration.SonarLoader;
import sonar.core.network.sync.SyncEnergyStorage;

public class SyncItemEnergyStorage
extends SyncEnergyStorage
implements ICapabilityProvider {
    protected ItemStack stack;

    public SyncItemEnergyStorage(ItemStack stack, int capacity) {
        super(capacity);
        this.stack = stack;
    }

    public SyncItemEnergyStorage(ItemStack stack, int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
        this.stack = stack;
    }

    public SyncItemEnergyStorage(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.stack = stack;
    }

    public SyncItemEnergyStorage setItemStack(ItemStack stack) {
        if (stack != null) {
            this.stack = stack;
            if (stack.func_77942_o()) {
                this.readFromNBT(stack.func_77978_p());
            }
        }
        return this;
    }

    @Override
    public void setChanged(boolean set) {
        super.setChanged(set);
        if (this.stack != null) {
            if (!this.stack.func_77942_o()) {
                this.stack.func_77982_d(new NBTTagCompound());
            }
            this.stack.func_77982_d(this.writeToNBT(this.stack.func_77978_p()));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return SonarLoader.teslaLoaded && (capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_PRODUCER || capability == TeslaCapabilities.CAPABILITY_HOLDER);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (SonarLoader.teslaLoaded && (capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_PRODUCER || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return (T)this;
        }
        return null;
    }
}

