/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.SyncPart;

public class SyncUUID
extends SyncPart {
    public UUID current = null;

    public SyncUUID(int id) {
        super(id);
    }

    public SyncUUID(String id) {
        super(id);
    }

    public UUID getUUID() {
        return this.current;
    }

    public void setObject(UUID id) {
        this.current = id;
        this.setChanged(true);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeBoolean(this.current != null);
        if (this.current != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.current.toString());
        }
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.current = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.current != null) {
            nbt.func_186854_a(this.getTagName(), this.current);
        }
        return nbt;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_186855_b(this.getTagName())) {
            this.current = nbt.func_186857_a(this.getTagName());
        } else if (nbt.func_74764_b(this.getTagName())) {
            this.current = SonarHelper.getGameProfileForUsername(nbt.func_74779_i(this.getTagName())).getId();
        }
    }
}

