/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import sonar.core.recipes.IRecipeItemStack;
import sonar.core.recipes.ISonarRecipeObject;

public class RecipeInterchangable
implements ISonarRecipeObject,
IRecipeItemStack {
    public List<ISonarRecipeObject> validInputs;
    public List<Object> cachedObjects = new ArrayList<Object>();

    public RecipeInterchangable(List<ISonarRecipeObject> validInputs) {
        this.validInputs = validInputs;
        validInputs.forEach(input -> this.cachedObjects.add(input.getValue()));
    }

    @Override
    public Object getValue() {
        return this.cachedObjects;
    }

    @Override
    public boolean matches(Object object) {
        for (ISonarRecipeObject recipeObject : this.validInputs) {
            if (!recipeObject.matches(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getOutputStack() {
        for (Object object : this.cachedObjects) {
            if (!(object instanceof ItemStack)) continue;
            return (ItemStack)object;
        }
        return null;
    }
}

