/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command;

import com.mojang.authlib.GameProfile;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.cyclops.cyclopscore.command.CommandMod;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public class CommandIgnite
extends CommandMod {
    public static final String NAME = "ignite";

    public CommandIgnite(ModBase mod) {
        super(mod, NAME);
    }

    @Override
    public String getFullCommand() {
        return super.getFullCommand() + " " + NAME;
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] parts, BlockPos blockPos) {
        return parts.length >= 1 ? CommandBase.func_71530_a((String[])parts, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z()) : null;
    }

    @Override
    public void processCommandHelp(ICommandSender icommandsender, String[] astring) throws CommandException {
        throw new WrongUsageException("/" + this.getFullCommand() + " <player> [duration]", new Object[0]);
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] parts) throws CommandException {
        if (parts.length < 1 || parts.length > 2 || parts[0].length() == 0) {
            this.processCommandHelp(sender, parts);
        }
        if (parts.length >= 1 && parts[0].length() > 0) {
            MinecraftServer minecraftserver = FMLCommonHandler.instance().getMinecraftServerInstance();
            GameProfile gameprofile = minecraftserver.func_152358_ax().func_152655_a(parts[0]);
            if (gameprofile == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(L10NHelpers.localize("chat.cyclopscore.command.invalidPlayer", parts[0])));
            } else {
                EntityPlayerMP player = minecraftserver.func_184103_al().func_152612_a(parts[0]);
                int duration = 2;
                if (parts.length > 1) {
                    try {
                        duration = Integer.parseInt(parts[1]);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                player.func_70015_d(duration);
                sender.func_145747_a((ITextComponent)new TextComponentString(L10NHelpers.localize("chat.cyclopscore.command.ignitedPlayer", parts[0], duration)));
            }
        }
    }
}

