/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Function;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;

@SideOnly(value=Side.CLIENT)
public class RenderHelpers {
    private static final Random rand = new Random();
    public static final Function<ResourceLocation, TextureAtlasSprite> TEXTURE_GETTER = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        }
    };

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void drawScaledCenteredString(FontRenderer fontRenderer, String string, int x, int y, int maxWidth, int color) {
        RenderHelpers.drawScaledCenteredString(fontRenderer, string, x, y, maxWidth, 1.0f, maxWidth, color);
    }

    public static void drawScaledCenteredString(FontRenderer fontRenderer, String string, int x, int y, int width, float originalScale, int maxWidth, int color) {
        float originalWidth = (float)fontRenderer.func_78256_a(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        RenderHelpers.drawScaledCenteredString(fontRenderer, string, x, y, width, scale, color);
    }

    public static void drawScaledCenteredString(FontRenderer fontRenderer, String string, int x, int y, int width, float scale, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int titleLength = fontRenderer.func_78256_a(string);
        int titleHeight = fontRenderer.field_78288_b;
        fontRenderer.func_78276_b(string, Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), Math.round((float)y / scale - (float)(titleHeight / 2)), color);
        GlStateManager.func_179121_F();
    }

    public static IBakedModel getBakedModel(IBlockState blockState) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher blockRendererDispatcher = mc.func_175602_ab();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        return blockModelShapes.func_178125_b(blockState);
    }

    public static IBakedModel getDynamicBakedModel(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        IBakedModel bakedModel = RenderHelpers.getBakedModel(blockState);
        return bakedModel;
    }

    public static void addBlockHitEffects(ParticleManager particleManager, World world, IBlockState blockState, BlockPos pos, EnumFacing side) {
        if (blockState.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB bb = blockState.func_185900_c((IBlockAccess)world, pos);
            double d0 = (double)i + rand.nextDouble() * (bb.field_72336_d - bb.field_72340_a - (double)(f * 2.0f)) + (double)f + bb.field_72340_a;
            double d1 = (double)j + rand.nextDouble() * (bb.field_72337_e - bb.field_72338_b - (double)(f * 2.0f)) + (double)f + bb.field_72338_b;
            double d2 = (double)k + rand.nextDouble() * (bb.field_72334_f - bb.field_72339_c - (double)(f * 2.0f)) + (double)f + bb.field_72339_c;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + bb.field_72338_b - (double)f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + bb.field_72337_e + (double)f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + bb.field_72339_c - (double)f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + bb.field_72334_f + (double)f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + bb.field_72340_a - (double)f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + bb.field_72336_d + (double)f;
            }
            Particle fx = new ParticleDigging.Factory().func_178902_a(-1, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)blockState)});
            particleManager.func_78873_a(fx);
        }
    }

    public static void renderItem(ItemStack itemStack) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.func_181564_a(itemStack, ItemCameraTransforms.TransformType.NONE);
    }

    public static void renderItem(ItemStack itemStack, ItemCameraTransforms.TransformType transformType) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        IBakedModel ibakedmodel = renderItem.func_175037_a().func_178089_a(itemStack);
        if (ibakedmodel.func_177556_c()) {
            GlStateManager.func_179152_a((float)40.0f, (float)40.0f, (float)40.0f);
            GlStateManager.func_179114_b((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179152_a((float)64.0f, (float)64.0f, (float)64.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179140_f();
        }
        renderItem.func_181564_a(itemStack, transformType);
    }

    public static TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block.func_176223_P());
    }

    public static TextureAtlasSprite getFluidIcon(Fluid fluid, EnumFacing side) {
        return RenderHelpers.getFluidIcon(new FluidStack(fluid, 1000), side);
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluid, EnumFacing side) {
        TextureAtlasSprite icon;
        BlockStaticLiquid defaultBlock;
        BlockStaticLiquid block = defaultBlock = Blocks.field_150355_j;
        if (fluid.getFluid().getBlock() != null) {
            block = fluid.getFluid().getBlock();
        }
        if (side == null) {
            side = EnumFacing.UP;
        }
        if ((icon = (TextureAtlasSprite)TEXTURE_GETTER.apply((Object)fluid.getFluid().getFlowing(fluid))) == null || side == EnumFacing.UP || side == EnumFacing.DOWN) {
            icon = (TextureAtlasSprite)TEXTURE_GETTER.apply((Object)fluid.getFluid().getStill(fluid));
        }
        if (icon == null && (icon = RenderHelpers.getBlockIcon((Block)block)) == null) {
            icon = RenderHelpers.getBlockIcon((Block)defaultBlock);
        }
        return icon;
    }

    public static void renderFluidContext(FluidStack fluid, double x, double y, double z, IFluidContextRender render) {
        if (fluid != null && fluid.amount > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            render.renderFluid(fluid);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    public static void renderTileFluidContext(FluidStack fluid, double x, double y, double z, TileEntity tile, IFluidContextRender render) {
        RenderHelpers.renderFluidContext(fluid, x, y, z, render);
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(FluidStack fluidStack) {
        int color = fluidStack.getFluid().getColor(fluidStack);
        return Helpers.intToRGB(color);
    }

    public static int getFluidBakedQuadColor(FluidStack fluidStack) {
        Triple<Float, Float, Float> colorParts = Helpers.intToRGB(fluidStack.getFluid().getColor(fluidStack));
        return Helpers.RGBAToInt((int)(((Float)colorParts.getRight()).floatValue() * 255.0f), (int)(((Float)colorParts.getMiddle()).floatValue() * 255.0f), (int)(((Float)colorParts.getLeft()).floatValue() * 255.0f), 255);
    }

    public static boolean isPointInRegion(int left, int top, int width, int height, int pointX, int pointY) {
        return pointX >= left && pointX < left + width && pointY >= top && pointY < top + height;
    }

    public static boolean isPointInRegion(Rectangle region, Point point) {
        return RenderHelpers.isPointInRegion(region.x, region.y, region.width, region.height, point.x, point.y);
    }

    public static interface IFluidContextRender {
        public void renderFluid(FluidStack var1);
    }
}

