/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.lwjgl.opengl.GL11;

public abstract class RecipeAppendix<T>
extends SectionAppendix {
    protected static final int SLOT_SIZE = 16;
    protected static final int TICK_DELAY = 30;
    protected T recipe;
    protected Map<AdvancedButton.Enum, ItemButton> renderItemHolders = Maps.newHashMap();

    public RecipeAppendix(IInfoBook infoBook, T recipe) {
        super(infoBook);
        this.recipe = recipe;
    }

    protected int getTick(GuiInfoBook gui) {
        return gui.getTick() / 30;
    }

    protected ItemStack prepareItemStacks(List<ItemStack> itemStacks, int tick) {
        if (itemStacks.size() == 0) {
            return null;
        }
        return this.prepareItemStack(itemStacks.get(tick % itemStacks.size()).func_77946_l(), tick);
    }

    protected ItemStack prepareItemStack(ItemStack itemStack, int tick) {
        if (itemStack.func_77952_i() == Short.MAX_VALUE) {
            LinkedList itemStacks = Lists.newLinkedList();
            itemStack.func_77973_b().func_150895_a(itemStack.func_77973_b(), null, (List)itemStacks);
            if (itemStacks.isEmpty()) {
                return itemStack;
            }
            return (ItemStack)itemStacks.get(tick % itemStacks.size());
        }
        return itemStack;
    }

    protected void renderItem(GuiInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButton.Enum buttonEnum) {
        this.renderItem(gui, x, y, itemStack, mx, my, true, buttonEnum);
    }

    protected void renderItem(GuiInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButton.Enum buttonEnum) {
        if (renderOverlays) {
            gui.drawOuterBorder(x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GL11.glEnable((int)2929);
        renderItem.func_180450_b(itemStack, x, y);
        if (renderOverlays) {
            renderItem.func_175030_a(Minecraft.func_71410_x().field_71466_p, itemStack, x, y);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        GL11.glDisable((int)2929);
        if (buttonEnum != null && renderOverlays) {
            this.renderItemHolders.get(buttonEnum).update(x, y, itemStack, gui);
        }
    }

    protected void renderItemTooltip(GuiInfoBook gui, int x, int y, ItemStack itemStack, int mx, int my) {
        GlStateManager.func_179094_E();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && itemStack != null) {
            gui.func_146285_a(itemStack, mx, my);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    @Override
    protected int getHeight() {
        return this.getHeightInner() + this.getAdditionalHeight();
    }

    protected abstract int getHeightInner();

    protected int getAdditionalHeight() {
        return 5;
    }

    @Override
    protected int getOffsetY() {
        return this.getAdditionalHeight();
    }

    protected abstract String getUnlocalizedTitle();

    @Override
    public final void drawElement(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = this.getAdditionalHeight();
        gui.drawOuterBorder(x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(L10NHelpers.localize(this.getUnlocalizedTitle()), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, Helpers.RGBToInt(120, 20, 30));
        this.drawElementInner(gui, x, y, width, height, page, mx, my);
    }

    @Override
    protected void postDrawElement(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        this.renderToolTips(gui, mx, my);
    }

    protected abstract void drawElementInner(GuiInfoBook var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected void renderToolTips(GuiInfoBook gui, int mx, int my) {
        for (ItemButton renderItemHolder : this.renderItemHolders.values()) {
            this.renderItemTooltip(gui, renderItemHolder.field_146128_h, renderItemHolder.field_146129_i, renderItemHolder.getItemStack(), mx, my);
        }
    }

    @Override
    public void preBakeElement(InfoSection infoSection) {
        this.renderItemHolders.clear();
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        infoSection.addAdvancedButtons(this.getPage(), this.renderItemHolders.values());
    }

    protected static class ItemButton
    extends AdvancedButton {
        private ItemStack itemStack;

        public void update(int x, int y, ItemStack itemStack, GuiInfoBook gui) {
            Pair<InfoSection, Integer> pair;
            ExtendedConfig<?> config;
            this.itemStack = itemStack;
            InfoSection target = null;
            if (this.itemStack != null && (config = ConfigHandler.getConfigFromItem(itemStack.func_77973_b())) != null && (pair = InfoBookParser.configLinks.get(config.getFullUnlocalizedName())) != null) {
                target = (InfoSection)pair.getLeft();
            }
            super.update(x, y, "empty", target, gui);
        }

        @Override
        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            if (this.isVisible() && this.isHover(mouseX, mouseY)) {
                this.gui.drawOuterBorder(this.field_146128_h, this.field_146129_i, 16, 16, 0.392f, 0.392f, 0.6f, 0.9f);
            }
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() && this.itemStack != null;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }
}

