/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.entity.player.InventoryPlayer;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;

public abstract class ScrollingInventoryContainer<E>
extends ExtendedInventoryContainer {
    private final List<E> unfilteredItems;
    private List<Pair<Integer, E>> filteredItems;
    private final List<E> visibleItems;
    private final IItemPredicate<E> itemSearchPredicate;
    private String lastSearchString = "";

    public ScrollingInventoryContainer(InventoryPlayer inventory, IGuiContainerProvider guiProvider, List<E> items, IItemPredicate<E> filterer) {
        super(inventory, guiProvider);
        this.unfilteredItems = Lists.newArrayList(items);
        this.filteredItems = Lists.newLinkedList();
        this.visibleItems = Arrays.asList(new Object[this.getPageSize() * this.getColumns()]);
        for (int i = 0; i < this.getPageSize(); ++i) {
            this.visibleItems.set(i, null);
        }
        this.itemSearchPredicate = filterer;
    }

    protected List<E> getUnfilteredItems() {
        return this.unfilteredItems;
    }

    protected List<Pair<Integer, E>> getFilteredItems() {
        return this.filteredItems;
    }

    public int getUnfilteredItemCount() {
        return this.getUnfilteredItems().size();
    }

    public int getFilteredItemCount() {
        return this.getFilteredItems().size();
    }

    public int getColumns() {
        return 1;
    }

    public int getScrollStepSize() {
        return this.getColumns();
    }

    public void scrollTo(float scroll) {
        this.onScroll();
        int elements = this.getFilteredItemCount() + this.getColumns() - 1 - this.getPageSize() * this.getColumns();
        int firstElement = (int)((double)(scroll * (float)elements) + 0.5);
        firstElement -= firstElement % this.getScrollStepSize();
        if (firstElement < 0) {
            firstElement = 0;
        }
        for (int i = 0; i < this.getPageSize(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                int index = i * this.getColumns() + j;
                int elementIndex = index + firstElement;
                this.visibleItems.set(index, null);
                if (elementIndex >= this.getFilteredItemCount()) continue;
                Pair<Integer, E> filteredItem = this.getFilteredItems().get(elementIndex);
                this.enableElementAt(index, (Integer)filteredItem.getLeft(), filteredItem.getRight());
            }
        }
    }

    protected void onScroll() {
    }

    public abstract int getPageSize();

    protected void enableElementAt(int visibleIndex, int elementIndex, E element) {
        this.visibleItems.set(visibleIndex, element);
    }

    public boolean isElementVisible(int row) {
        return row < this.getPageSize() && this.getVisibleElement(row) != null;
    }

    public E getVisibleElement(int row) {
        if (row >= this.visibleItems.size()) {
            return null;
        }
        return this.visibleItems.get(row);
    }

    public void refreshFilter() {
        this.updateFilter(this.lastSearchString);
    }

    public void updateFilter(String searchString) {
        Pattern pattern;
        this.lastSearchString = searchString;
        try {
            pattern = Pattern.compile(".*" + searchString.toLowerCase() + ".*");
        }
        catch (PatternSyntaxException e) {
            pattern = Pattern.compile(".*");
        }
        this.filteredItems = this.filter(this.getUnfilteredItems(), this.itemSearchPredicate, pattern);
        this.scrollTo(0.0f);
    }

    protected List<Pair<Integer, E>> filter(List<E> input, IItemPredicate<E> predicate, Pattern pattern) {
        LinkedList filtered = Lists.newLinkedList();
        int i = 0;
        for (E item : input) {
            if (predicate.apply(item, pattern) && this.additionalApplies(item)) {
                filtered.add(Pair.of((Object)i, item));
            }
            ++i;
        }
        return filtered;
    }

    protected boolean additionalApplies(E item) {
        return true;
    }

    public static interface IItemPredicate<E> {
        public boolean apply(E var1, Pattern var2);
    }
}

