/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.particle.ParticleLava;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.packet.PlayerPositionPacket;

public class RingOfFirePacket
extends PlayerPositionPacket {
    private static final double RING_AREA = (double)0.9f;

    public RingOfFirePacket() {
    }

    public RingOfFirePacket(EntityPlayer player) {
        super(player);
    }

    @SideOnly(value=Side.CLIENT)
    private static void showFireRing(World world, Vec3d pos) {
        double area = 0.9f;
        int points = 40;
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            double u = Math.PI * 2 * (point / (double)points);
            double xOffset = Math.cos(u) * area;
            double yOffset = 0.0;
            double zOffset = Math.sin(u) * area;
            double xCoord = pos.field_72450_a;
            double yCoord = pos.field_72448_b;
            double zCoord = pos.field_72449_c;
            double particleX = xCoord + xOffset + (double)(world.field_73012_v.nextFloat() / 5.0f);
            double particleY = yCoord + yOffset + (double)(world.field_73012_v.nextFloat() / 5.0f);
            double particleZ = zCoord + zOffset + (double)(world.field_73012_v.nextFloat() / 5.0f);
            float particleMotionX = (float)xOffset / 50.0f;
            float particleMotionY = 0.01f;
            float particleMotionZ = (float)zOffset / 50.0f;
            if (world.field_73012_v.nextInt(20) == 0) {
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(new ParticleLava.Factory().func_178902_a(EnumParticleTypes.LAVA.func_179348_c(), world, particleX, particleY, particleZ, 0.0, 0.0, 0.0, new int[]{0}));
                continue;
            }
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(new ParticleFlame.Factory().func_178902_a(0, world, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ, new int[0]));
        }
    }

    @Override
    protected PlayerPositionPacket create(EntityPlayer player, int range) {
        return new RingOfFirePacket(player);
    }

    @Override
    protected ModBase getModInstance() {
        return CyclopsCore._instance;
    }

    @Override
    protected void performClientAction(World world, EntityPlayer player) {
        RingOfFirePacket.showFireRing(world, this.position);
    }
}

