/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tileentity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public class CyclopsTileEntity
extends TileEntity
implements INBTProvider {
    private static final int UPDATE_BACKOFF_TICKS = 1;
    @NBTPersist
    private Boolean rotatable = false;
    private EnumFacing rotation = EnumFacing.NORTH;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);
    private boolean shouldSendUpdate = false;
    private int sendUpdateBackoff = 0;
    private final boolean ticking;
    private final Map<Pair<Capability<?>, EnumFacing>, Object> capabilities = Maps.newHashMap();

    public CyclopsTileEntity() {
        this.sendUpdateBackoff = (int)Math.round(Math.random() * (double)this.getUpdateBackoffTicks());
        this.ticking = this instanceof ITickingTile;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    protected boolean isTicking() {
        return this.ticking;
    }

    public final void sendUpdate() {
        if (!this.isTicking()) {
            throw new RuntimeException("If you want to update, you must implement ITickingTile. This is a mod error.");
        }
        this.shouldSendUpdate = true;
    }

    public final void sendImmediateUpdate() {
        this.sendUpdate();
        this.sendUpdateBackoff = 0;
    }

    private void updateTicking() {
        this.updateTileEntity();
        this.trySendActualUpdate();
    }

    protected void updateTileEntity() {
    }

    private void trySendActualUpdate() {
        --this.sendUpdateBackoff;
        if (this.sendUpdateBackoff <= 0) {
            this.sendUpdateBackoff = this.getUpdateBackoffTicks();
            if (this.shouldSendUpdate) {
                this.shouldSendUpdate = false;
                this.beforeSendUpdate();
                this.onSendUpdate();
                this.afterSendUpdate();
            }
        }
    }

    protected void onSendUpdate() {
        BlockHelpers.markForUpdate(this.func_145831_w(), this.func_174877_v());
    }

    protected void beforeSendUpdate() {
    }

    protected void afterSendUpdate() {
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.getNBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound tag = packet.func_148857_g();
        this.func_145839_a(tag);
        this.onUpdateReceived();
    }

    public void onUpdateReceived() {
    }

    protected int getUpdateBackoffTicks() {
        return 1;
    }

    public void destroy() {
        this.func_145843_s();
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.writeGeneratedFieldsToNBT(tag);
        tag.func_74768_a("rotation", this.rotation.ordinal());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readGeneratedFieldsFromNBT(tag);
        EnumFacing foundRotation = EnumFacing.field_82609_l[tag.func_74762_e("rotation")];
        if (foundRotation != null) {
            this.rotation = foundRotation;
        }
        this.onLoad();
    }

    public void onLoad() {
    }

    public NBTTagCompound getNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.func_189515_b(tag);
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        return this.getNBTTagCompound();
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public EnumFacing getRotation() {
        return this.rotation;
    }

    public void setRotation(EnumFacing rotation) {
        this.rotation = rotation;
    }

    public ConfigurableBlockContainer getBlock() {
        return (ConfigurableBlockContainer)this.func_145838_q();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.capabilities != null && this.capabilities.containsKey(Pair.of(capability, (Object)facing)) || facing != null && this.capabilities != null && this.capabilities.containsKey(Pair.of(capability, null)) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.capabilities != null) {
            Object value = this.capabilities.get(Pair.of(capability, (Object)facing));
            if (value == null && facing != null) {
                value = this.capabilities.get(Pair.of(capability, null));
            }
            if (value != null) {
                return (T)value;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public <T> void addCapabilityInternal(Capability<T> capability, T value) {
        this.capabilities.put(Pair.of(capability, null), value);
    }

    public <T> void addCapabilitySided(Capability<T> capability, EnumFacing facing, T value) {
        this.capabilities.put(Pair.of(capability, (Object)facing), value);
    }

    protected Map<Pair<Capability<?>, EnumFacing>, Object> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void writeGeneratedFieldsToNBT(NBTTagCompound tag) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(tag);
    }

    @Override
    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(tag);
    }

    public static class TickingTileComponent
    implements ITickingTile {
        private final CyclopsTileEntity tile;

        public TickingTileComponent(CyclopsTileEntity tile) {
            this.tile = tile;
        }

        public void func_73660_a() {
            this.tile.updateTicking();
        }
    }

    public static interface ITickingTile
    extends ITickable {
    }
}

