/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tileentity;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.tileentity.InventoryTileEntity;

public abstract class TankInventoryTileEntity
extends InventoryTileEntity {
    private SingleUseTank tank;
    protected int tankSize;
    private String tankName;
    protected boolean sendUpdateOnTankChanged = false;
    protected final EnumFacingMap<IFluidHandler> sidedFluidHandlers;

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, int stackSize) {
        super(inventorySize, inventoryName, stackSize);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.setSendUpdateOnTankChanged(true);
        this.tank = this.newTank(tankName, tankSize);
        this.sidedFluidHandlers = EnumFacingMap.newMap();
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.tank);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side, this.tank);
        }
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName) {
        this(inventorySize, inventoryName, tankSize, tankName, 64);
    }

    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new SingleUseTank(tankName, tankSize, this);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int stackSize, int tankSize, String tankName) {
        super(inventorySize, inventoryName, stackSize);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.setSendUpdateOnTankChanged(true);
        this.tank = this.newTank(tankName, tankSize);
        this.sidedFluidHandlers = EnumFacingMap.newMap();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side, this.tank);
        }
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, Fluid acceptedFluid) {
        this(inventorySize, inventoryName, tankSize, tankName);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.tank.setAcceptedFluid(acceptedFluid);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int stackSize, int tankSize, String tankName, Fluid acceptedFluid) {
        this(inventorySize, inventoryName, stackSize, tankSize, tankName);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.tank.setAcceptedFluid(acceptedFluid);
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        return tag;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean isSendUpdateOnTankChanged() {
        return this.sendUpdateOnTankChanged;
    }

    public void setSendUpdateOnTankChanged(boolean sendUpdateOnTankChanged) {
        this.sendUpdateOnTankChanged = sendUpdateOnTankChanged;
    }

    @Override
    protected void onSendUpdate() {
        super.onSendUpdate();
        if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_185912_n()) {
            this.field_145850_b.func_175685_c(this.func_174877_v(), (Block)this.getBlock());
        }
    }
}

