/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcjty.lib.container.ContainerFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryHelper {
    private final TileEntity tileEntity;
    private final ContainerFactory containerFactory;
    private ItemStack[] stacks;
    private int count;

    public InventoryHelper(TileEntity tileEntity, ContainerFactory containerFactory, int count) {
        this.tileEntity = tileEntity;
        this.containerFactory = containerFactory;
        this.stacks = new ItemStack[count];
        this.count = count;
    }

    public void setNewCount(int newcount) {
        this.count = newcount;
        ItemStack[] newstacks = new ItemStack[newcount];
        System.arraycopy(this.stacks, 0, newstacks, 0, Math.min(this.stacks.length, newstacks.length));
        this.stacks = newstacks;
    }

    public ItemStack removeStackFromSlot(int index) {
        ItemStack stack = this.stacks[index];
        this.setStackInSlot(index, null);
        return stack;
    }

    public static void handleSlot(TileEntity tileEntity, int slot, Consumer<ItemStack> consumer) {
        InventoryHelper.handleSlot(tileEntity, slot, -1, consumer);
    }

    public static void handleSlot(TileEntity tileEntity, int slot, int amount, Consumer<ItemStack> consumer) {
        IInventory inventory;
        ItemStack item;
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack item2 = capability.getStackInSlot(slot);
            if (item2 != null) {
                ItemStack stack;
                if (amount == -1) {
                    amount = item2.field_77994_a;
                }
                if ((stack = capability.extractItem(slot, amount, false)) != null) {
                    consumer.accept(stack);
                }
            }
        } else if (tileEntity instanceof IInventory && (item = (inventory = (IInventory)tileEntity).func_70301_a(slot)) != null) {
            ItemStack stack;
            if (amount == -1) {
                amount = item.field_77994_a;
            }
            if ((stack = inventory.func_70298_a(slot, amount)) != null) {
                consumer.accept(stack);
            }
        }
    }

    public static ItemStack extractItem(TileEntity tileEntity, int slot, int amount) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.extractItem(slot, amount, false);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70298_a(slot, amount);
        }
        return null;
    }

    public static int getInventorySize(TileEntity tileEntity) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (capability == null) {
                return 0;
            }
            return capability.getSlots();
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70302_i_();
        }
        return 0;
    }

    public static ItemStack getSlot(TileEntity tileEntity, int slot) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.getStackInSlot(slot);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70301_a(slot);
        }
        return null;
    }

    public static boolean isInventory(TileEntity te) {
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return true;
        }
        return te instanceof IInventory;
    }

    public static Stream<ItemStack> getItems(TileEntity tileEntity, Predicate<ItemStack> predicate) {
        Stream.Builder<ItemStack> builder;
        block3: {
            block2: {
                builder = Stream.builder();
                if (tileEntity == null || !tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) break block2;
                IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (int i = 0; i < capability.getSlots(); ++i) {
                    ItemStack itemStack = capability.getStackInSlot(i);
                    if (itemStack == null || !predicate.test(itemStack)) continue;
                    builder.add(itemStack);
                }
                break block3;
            }
            if (!(tileEntity instanceof IInventory)) break block3;
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemStack = inventory.func_70301_a(i);
                if (itemStack == null || !predicate.test(itemStack)) continue;
                builder.add(itemStack);
            }
        }
        return builder.build();
    }

    public static boolean installModule(EntityPlayer player, ItemStack heldItem, EnumHand hand, BlockPos pos, int start, int stop) {
        World world = player.func_130014_f_();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (int i = start; i <= stop; ++i) {
                if (inventory.func_70301_a(i) != null) continue;
                ItemStack copy = heldItem.func_77946_l();
                copy.field_77994_a = 1;
                inventory.func_70299_a(i, copy);
                --heldItem.field_77994_a;
                if (heldItem.field_77994_a == 0) {
                    player.func_184611_a(hand, null);
                }
                if (world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentString("Installed module"));
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack insertItem(World world, BlockPos pos, EnumFacing direction, ItemStack s) {
        TileEntity te = world.func_175625_s(direction == null ? pos : pos.func_177972_a(direction));
        if (te != null) {
            EnumFacing opposite;
            EnumFacing enumFacing = opposite = direction == null ? null : direction.func_176734_d();
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, opposite)) {
                IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, opposite);
                s = ItemHandlerHelper.insertItem((IItemHandler)capability, (ItemStack)s, (boolean)false);
                if (s == null) {
                    return null;
                }
            } else if (te instanceof IInventory) {
                int i = InventoryHelper.mergeItemStackSafe((IInventory)te, true, opposite, s, 0, ((IInventory)te).func_70302_i_(), null);
                if (i == 0) {
                    return null;
                }
                s.field_77994_a = i;
            }
        }
        return s;
    }

    private static boolean insertItemsItemHandlerWithUndo(IItemHandler dest, List<ItemStack> stacks, boolean simulate) {
        if (dest == null || stacks == null || stacks.isEmpty()) {
            return true;
        }
        if (stacks.size() == 1) {
            ItemStack stack = stacks.get(0);
            return (stack = ItemHandlerHelper.insertItem((IItemHandler)dest, (ItemStack)stack, (boolean)simulate)) == null;
        }
        List s = stacks.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        for (int i = 0; i < dest.getSlots(); ++i) {
            boolean empty = true;
            for (int j = 0; j < stacks.size(); ++j) {
                ItemStack stack = dest.insertItem(i, (ItemStack)s.get(j), simulate);
                if (stack != null && stack.field_77994_a > 0) {
                    empty = false;
                }
                s.set(j, stack);
            }
            if (!empty) continue;
            return true;
        }
        return false;
    }

    public static boolean insertItemsAtomic(List<ItemStack> items, TileEntity te, EnumFacing side) {
        if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            HashMap<Integer, ItemStack> undo = new HashMap<Integer, ItemStack>();
            for (ItemStack item : items) {
                int remaining = InventoryHelper.mergeItemStackSafe(inventory, false, EnumFacing.DOWN, item, 0, inventory.func_70302_i_(), undo);
                if (remaining <= 0) continue;
                InventoryHelper.undo(undo, inventory);
                return false;
            }
        } else if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (!InventoryHelper.insertItemsItemHandlerWithUndo(capability, items, true)) {
                return false;
            }
            InventoryHelper.insertItemsItemHandlerWithUndo(capability, items, false);
        } else {
            return false;
        }
        return true;
    }

    public static void undo(Map<Integer, ItemStack> undo, IInventory inventory) {
        for (Map.Entry<Integer, ItemStack> entry : undo.entrySet()) {
            inventory.func_70299_a(entry.getKey().intValue(), entry.getValue());
        }
    }

    public static int mergeItemStackSafe(IInventory inventory, boolean checkSlots, EnumFacing side, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        if (inventory instanceof ISidedInventory) {
            return InventoryHelper.mergeItemStackInternal(inventory, (ISidedInventory)inventory, checkSlots, side, result, start, stop, undo);
        }
        return InventoryHelper.mergeItemStackInternal(inventory, null, checkSlots, side, result, start, stop, undo);
    }

    public static int mergeItemStack(IInventory inventory, boolean checkSlots, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        return InventoryHelper.mergeItemStackInternal(inventory, null, checkSlots, null, result, start, stop, undo);
    }

    private static int mergeItemStackInternal(IInventory inventory, ISidedInventory sidedInventory, boolean checkSlots, EnumFacing side, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        ItemStack itemstack1;
        int k;
        int itemsToPlace = result.field_77994_a;
        if (result.func_77985_e()) {
            for (k = start; itemsToPlace > 0 && k < stop; ++k) {
                itemstack1 = inventory.func_70301_a(k);
                if (!InventoryHelper.isItemStackConsideredEqual(result, itemstack1) || sidedInventory != null && !sidedInventory.func_180462_a(k, result, side) || checkSlots && !inventory.func_94041_b(k, result)) continue;
                int l = itemstack1.field_77994_a + itemsToPlace;
                if (l <= result.func_77976_d()) {
                    if (undo != null && !undo.containsKey(k)) {
                        undo.put(k, itemstack1.func_77946_l());
                    }
                    itemsToPlace = 0;
                    itemstack1.field_77994_a = l;
                    inventory.func_70296_d();
                    continue;
                }
                if (itemstack1.field_77994_a >= result.func_77976_d()) continue;
                if (undo != null && !undo.containsKey(k)) {
                    undo.put(k, itemstack1.func_77946_l());
                }
                itemsToPlace -= result.func_77976_d() - itemstack1.field_77994_a;
                itemstack1.field_77994_a = result.func_77976_d();
                inventory.func_70296_d();
            }
        }
        if (itemsToPlace > 0) {
            for (k = start; k < stop; ++k) {
                itemstack1 = inventory.func_70301_a(k);
                if (itemstack1 != null || sidedInventory != null && !sidedInventory.func_180462_a(k, result, side) || checkSlots && !inventory.func_94041_b(k, result)) continue;
                if (undo != null && !undo.containsKey(k)) {
                    undo.put(k, null);
                }
                ItemStack copy = result.func_77946_l();
                copy.field_77994_a = itemsToPlace;
                inventory.func_70299_a(k, copy);
                inventory.func_70296_d();
                itemsToPlace = 0;
                break;
            }
        }
        return itemsToPlace;
    }

    private static boolean isItemStackConsideredEqual(ItemStack result, ItemStack itemstack1) {
        return itemstack1 != null && itemstack1.func_77973_b() == result.func_77973_b() && (!result.func_77981_g() || result.func_77952_i() == itemstack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)result, (ItemStack)itemstack1);
    }

    public int getCount() {
        return this.count;
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= this.stacks.length) {
            return null;
        }
        return this.stacks[index];
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (index >= this.stacks.length) {
            return;
        }
        this.stacks[index] = stack;
    }

    public boolean containsItem(int index) {
        if (index >= this.stacks.length) {
            return false;
        }
        return this.stacks[index] != null;
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.length) {
            return null;
        }
        if (this.containerFactory.isGhostSlot(index) || this.containerFactory.isGhostOutputSlot(index)) {
            ItemStack old = this.stacks[index];
            this.stacks[index] = null;
            if (old == null) {
                return null;
            }
            old.field_77994_a = 0;
            return old;
        }
        if (this.stacks[index] != null) {
            if (this.stacks[index].field_77994_a <= amount) {
                ItemStack old = this.stacks[index];
                this.stacks[index] = null;
                this.tileEntity.func_70296_d();
                return old;
            }
            ItemStack its = this.stacks[index].func_77979_a(amount);
            if (this.stacks[index].field_77994_a == 0) {
                this.stacks[index] = null;
            }
            this.tileEntity.func_70296_d();
            return its;
        }
        return null;
    }

    public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
        if (index >= this.stacks.length) {
            return;
        }
        if (this.containerFactory.isGhostSlot(index)) {
            if (stack != null) {
                this.stacks[index] = stack.func_77946_l();
                if (index < 9) {
                    this.stacks[index].field_77994_a = 1;
                }
            } else {
                this.stacks[index] = null;
            }
        } else if (this.containerFactory.isGhostOutputSlot(index)) {
            this.stacks[index] = stack != null ? stack.func_77946_l() : null;
        } else {
            this.stacks[index] = stack;
            if (stack != null && stack.field_77994_a > stackLimit) {
                stack.field_77994_a = stackLimit;
            }
            this.tileEntity.func_70296_d();
        }
    }

    public static void compactStacks(InventoryHelper helper, int start, int max) {
        InventoryHelper.compactStacks(helper.stacks, start, max);
    }

    public static void compactStacks(ItemStack[] stacks, int start, int max) {
        ItemStack stack;
        int i;
        InventoryBasic inv = new InventoryBasic("temp", true, max);
        for (i = 0; i < max; ++i) {
            stack = stacks[i + start];
            if (stack == null) continue;
            InventoryHelper.mergeItemStack((IInventory)inv, false, stack, 0, max, null);
        }
        for (i = 0; i < max; ++i) {
            stack = inv.func_70301_a(i);
            if (stack != null && stack.field_77994_a == 0) {
                stack = null;
            }
            stacks[i + start] = stack;
        }
    }
}

