/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.icons.IconManager;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import org.lwjgl.input.Mouse;

public class WindowManager {
    private IconManager iconManager = new IconManager(this);
    private final GuiScreen gui;
    private List<Window> windows = new ArrayList<Window>();
    private List<Window> modalWindows = new ArrayList<Window>();
    private int mouseWheel = -1;

    public WindowManager(GuiScreen gui) {
        this.gui = gui;
    }

    public GuiScreen getGui() {
        return this.gui;
    }

    public IconManager getIconManager() {
        return this.iconManager;
    }

    public void clearFocus() {
        Stream.concat(this.windows.stream(), this.modalWindows.stream()).forEach(w -> w.setFocus(null));
    }

    public void setFocus(Widget w) {
        this.clearFocus();
        Stream.concat(this.windows.stream(), this.modalWindows.stream()).filter(window -> window.isWidgetOnWindow(w)).findFirst().ifPresent(window -> window.setTextFocus(w));
    }

    public WindowManager addWindow(Window w) {
        this.windows.add(w);
        w.setWindowManager(this);
        return this;
    }

    public WindowManager addModalWindow(Window w) {
        this.modalWindows.add(w);
        w.setWindowManager(this);
        return this;
    }

    public Window createModalWindow(Widget topLevel) {
        Window w = new Window(this.gui, topLevel);
        this.addModalWindow(w);
        return w;
    }

    public void closeWindow(Window window) {
        if (this.windows.contains(window)) {
            this.windows.remove(window);
        } else if (this.modalWindows.contains(window)) {
            this.modalWindows.remove(window);
        }
    }

    public int getMouseWheel() {
        return this.mouseWheel;
    }

    public void draw() {
        this.mouseWheel = Mouse.getDWheel();
        this.windows.stream().forEach(w -> w.draw());
        this.modalWindows.stream().forEach(w -> w.draw());
        this.iconManager.draw(Minecraft.func_71410_x(), (Gui)this.gui);
    }

    private Stream<Window> getInteractableWindows() {
        if (this.modalWindows.isEmpty()) {
            return this.windows.stream();
        }
        Window window = this.modalWindows.get(this.modalWindows.size() - 1);
        return Stream.builder().add(window).build();
    }

    public void drawTooltips() {
        int x = Mouse.getEventX() * this.gui.field_146294_l / this.gui.field_146297_k.field_71443_c;
        int y = this.gui.field_146295_m - Mouse.getEventY() * this.gui.field_146295_m / this.gui.field_146297_k.field_71440_d - 1;
        this.getInteractableWindows().forEach(w -> {
            List<String> tooltips = w.getTooltips();
            if (tooltips != null) {
                GenericGuiContainer gui = (GenericGuiContainer)this.gui;
                gui.drawHoveringText(tooltips, w.getTooltipItems(), x - gui.getGuiLeft(), y - gui.getGuiTop(), gui.field_146297_k.field_71466_p);
            }
        });
        RenderHelper.func_74520_c();
    }

    public Optional<Widget> findWidgetAtPosition(int x, int y) {
        return this.windows.stream().map(w -> w.getWidgetAtPosition(x, y)).filter(w -> w != null).findFirst();
    }

    public void mouseClicked(int x, int y, int button) throws IOException {
        if (!this.iconManager.isClickHoldToDrag() && this.iconManager.isDragging()) {
            if (button == 1) {
                this.iconManager.cancelDragging();
            } else {
                this.iconManager.stopDragging(x, y);
            }
            return;
        }
        this.getInteractableWindows().forEach(w -> w.mouseClicked(x, y, button));
    }

    public void handleMouseInput() throws IOException {
        this.getInteractableWindows().forEach(Window::handleMouseInput);
    }

    public void mouseReleased(int x, int y, int state) {
        if (this.iconManager.isClickHoldToDrag() && this.iconManager.isDragging()) {
            this.iconManager.stopDragging(x, y);
        }
        this.getInteractableWindows().forEach(w -> w.mouseMovedOrUp(x, y, state));
    }

    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return this.getInteractableWindows().allMatch(w -> !w.keyTyped(typedChar, keyCode));
    }
}

