/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class BlockRender
extends AbstractWidget<BlockRender> {
    private Object renderItem = null;
    private int offsetX = 0;
    private int offsetY = 0;
    private long prevTime = -1L;
    private boolean hilightOnHover = false;
    private List<BlockRenderEvent> selectionEvents = null;

    public Object getRenderItem() {
        return this.renderItem;
    }

    public BlockRender setRenderItem(Object renderItem) {
        this.renderItem = renderItem;
        return this;
    }

    public BlockRender(Minecraft mc, Gui gui) {
        super(mc, gui);
        this.setDesiredHeight(16);
        this.setDesiredWidth(16);
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public BlockRender setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public BlockRender setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    public boolean isHilightOnHover() {
        return this.hilightOnHover;
    }

    public BlockRender setHilightOnHover(boolean hilightOnHover) {
        this.hilightOnHover = hilightOnHover;
        return this;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        super.draw(window, x, y);
        if (this.renderItem != null) {
            int xx = x + this.bounds.x + this.offsetX;
            int yy = y + this.bounds.y + this.offsetY;
            RenderHelper.renderObject(this.mc, xx, yy, this.renderItem, false);
            if (this.hilightOnHover && this.isHovering()) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                RenderHelper.drawVerticalGradientRect(xx, yy, xx + 16, yy + 16, -2130706433, -2130706433);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179126_j();
            }
        }
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            this.fireSelectionEvents();
            long t = System.currentTimeMillis();
            if (this.prevTime != -1L && t - this.prevTime < 250L) {
                this.fireDoubleClickEvent();
            }
            this.prevTime = t;
            return this;
        }
        return null;
    }

    public BlockRender addSelectionEvent(BlockRenderEvent event) {
        if (this.selectionEvents == null) {
            this.selectionEvents = new ArrayList<BlockRenderEvent>();
        }
        this.selectionEvents.add(event);
        return this;
    }

    public void removeSelectionEvent(BlockRenderEvent event) {
        if (this.selectionEvents != null) {
            this.selectionEvents.remove(event);
        }
    }

    private void fireSelectionEvents() {
        if (this.selectionEvents != null) {
            for (BlockRenderEvent event : this.selectionEvents) {
                event.select(this);
            }
        }
    }

    private void fireDoubleClickEvent() {
        if (this.selectionEvents != null) {
            for (BlockRenderEvent event : this.selectionEvents) {
                event.doubleClick(this);
            }
        }
    }
}

