/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network.clientinfo;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.lib.network.clientinfo.PacketReturnInfoToClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class PacketGetInfoFromServer
implements IMessage {
    private InfoPacketServer packet;
    private String modid;

    public void fromBytes(ByteBuf buf) {
        int id = buf.readInt();
        Class<? extends InfoPacketServer> clazz = PacketHandler.getServerInfoPacket(id);
        try {
            this.packet = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.packet.fromBytes(buf);
        this.modid = NetworkTools.readString(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(PacketHandler.getServerInfoPacketId(this.packet.getClass()).intValue());
        this.packet.toBytes(buf);
        NetworkTools.writeString(buf, this.modid);
    }

    public PacketGetInfoFromServer() {
    }

    public PacketGetInfoFromServer(String modid, InfoPacketServer packet) {
        this.packet = packet;
        this.modid = modid;
    }

    public static class Handler
    implements IMessageHandler<PacketGetInfoFromServer, IMessage> {
        public IMessage onMessage(PacketGetInfoFromServer message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> message.packet.onMessageServer(ctx.getServerHandler().field_147369_b).ifPresent(p -> this.sendReplyToClient(message.modid, (InfoPacketClient)p, ctx.getServerHandler().field_147369_b)));
            return null;
        }

        private void sendReplyToClient(String modid, InfoPacketClient reply, EntityPlayerMP player) {
            SimpleNetworkWrapper wrapper = PacketHandler.modNetworking.get(modid);
            PacketReturnInfoToClient msg = new PacketReturnInfoToClient(reply);
            wrapper.sendTo((IMessage)msg, player);
        }
    }
}

