/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.block;

import ipsis.woot.block.BlockWoot;
import ipsis.woot.manager.EnumSpawnerUpgrade;
import ipsis.woot.reference.Reference;
import ipsis.woot.reference.Settings;
import ipsis.woot.tileentity.TileEntityMobFactoryUpgrade;
import ipsis.woot.util.StringHelper;
import java.util.List;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMobFactoryUpgradeBase
extends BlockWoot
implements ITileEntityProvider {
    public BlockMobFactoryUpgradeBase(String basename) {
        super(Material.field_151576_e, basename);
        this.setRegistryName(Reference.MOD_ID_LOWER, basename);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMobFactoryUpgrade();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityMobFactoryUpgrade te = (TileEntityMobFactoryUpgrade)worldIn.func_175625_s(pos);
        te.blockAdded();
    }

    public void getUpgradeTooltip(EnumSpawnerUpgrade u, List<String> toolTip, boolean showAdvanced, int meta, boolean detail) {
        switch (u) {
            case RATE_I: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_rate_effect"), Settings.rateITicks));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.rateIRfTick));
                break;
            }
            case RATE_II: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_rate_effect"), Settings.rateIITicks));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.rateIIRfTick));
                break;
            }
            case RATE_III: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_rate_effect"), Settings.rateIIITicks));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.rateIIIRfTick));
                break;
            }
            case LOOTING_I: {
                toolTip.add(StringHelper.localize("tooltip.Woot:upgrade_lootingI_effect"));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.lootingIRfTick));
                break;
            }
            case LOOTING_II: {
                toolTip.add(StringHelper.localize("tooltip.Woot:upgrade_lootingII_effect"));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.lootingIIRfTick));
                break;
            }
            case LOOTING_III: {
                toolTip.add(StringHelper.localize("tooltip.Woot:upgrade_lootingIII_effect"));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.lootingIIIRfTick));
                break;
            }
            case XP_I: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_xp_base_effect"), Settings.xpIBoost));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.xpIRfTick));
                break;
            }
            case XP_II: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_xp_effect"), Settings.xpIIBoost));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.xpIIRfTick));
                break;
            }
            case XP_III: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_xp_effect"), Settings.xpIIIBoost));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.xpIIIRfTick));
                break;
            }
            case MASS_I: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_mass_effect"), Settings.massIMobs));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.massIRfTick));
                break;
            }
            case MASS_II: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_mass_effect"), Settings.massIIMobs));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.massIIRfTick));
                break;
            }
            case MASS_III: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_mass_effect"), Settings.massIIIMobs));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.massIIIRfTick));
                break;
            }
            case DECAPITATE_I: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_decap_effect"), Settings.decapitateIChance));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.decapitateIRfTick));
                break;
            }
            case DECAPITATE_II: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_decap_effect"), Settings.decapitateIIChance));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.decapitateIIRfTick));
                break;
            }
            case DECAPITATE_III: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_decap_effect"), Settings.decapitateIIIChance));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.decapitateIIIRfTick));
                break;
            }
            case EFFICIENCY_I: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_efficiency_effect"), Settings.efficiencyI));
                break;
            }
            case EFFICIENCY_II: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_efficiency_effect"), Settings.efficiencyII));
                break;
            }
            case EFFICIENCY_III: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_efficiency_effect"), Settings.efficiencyIII));
                break;
            }
            case BLOODMAGIC_I: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_bloodmagic_effect"), Settings.bmICount));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.bmIRfTick));
                break;
            }
            case BLOODMAGIC_II: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_bloodmagic_effect"), Settings.bmIICount));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.bmIIRfTick));
                break;
            }
            case BLOODMAGIC_III: {
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_bloodmagic_effect"), Settings.bmIIICount));
                toolTip.add(String.format(StringHelper.localize("tooltip.Woot:upgrade_cost"), Settings.bmIIIRfTick));
                break;
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (blockAccess.func_175625_s(pos) instanceof TileEntityMobFactoryUpgrade) {
            boolean validBlock;
            TileEntityMobFactoryUpgrade te = (TileEntityMobFactoryUpgrade)blockAccess.func_175625_s(pos);
            boolean bl = validBlock = !this.isAir(blockState, blockAccess, pos.func_177972_a(side.func_176734_d()));
            if (validBlock && !te.isClientFormed()) {
                return true;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public static int getBlockSplitMeta(EnumSpawnerUpgrade u) {
        if (u.ordinal() >= EnumSpawnerUpgrade.RATE_I.ordinal() && u.ordinal() <= EnumSpawnerUpgrade.DECAPITATE_III.ordinal()) {
            return u.ordinal();
        }
        return u.ordinal() - (EnumSpawnerUpgrade.DECAPITATE_III.ordinal() + 1);
    }
}

