/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.client.manual;

import ipsis.woot.client.manual.IBookPage;
import ipsis.woot.util.StringHelper;

public class Section {
    String tag;
    private IBookPage[] pages;

    public Section(String tag, IBookPage ... pages) {
        this.tag = tag;
        this.pages = pages;
        for (IBookPage page : pages) {
            page.setSection(this);
        }
    }

    IBookPage getFirstPage() {
        if (this.pages.length == 0) {
            return null;
        }
        return this.pages[0];
    }

    IBookPage getLastPage() {
        if (this.pages.length == 0) {
            return null;
        }
        return this.pages[this.pages.length - 1];
    }

    IBookPage getNextPage(IBookPage currPage) {
        IBookPage nextPage = null;
        for (int i = 0; i < this.pages.length && nextPage == null; ++i) {
            if (this.pages[i] != currPage || i >= this.pages.length - 1) continue;
            nextPage = this.pages[i + 1];
        }
        return nextPage;
    }

    IBookPage getPrevPage(IBookPage currPage) {
        IBookPage prevPage = null;
        for (int i = 0; i < this.pages.length && prevPage == null; ++i) {
            if (this.pages[i] != currPage || i <= 0) continue;
            prevPage = this.pages[i - 1];
        }
        return prevPage;
    }

    public String getTitle() {
        return StringHelper.localize("book.Woot:" + this.tag + ".title");
    }
}

