/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.handler;

import ipsis.Woot;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.reference.Lang;
import ipsis.woot.reference.Settings;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryTier;
import ipsis.woot.util.StringHelper;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration configuration;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigHandler.loadConfiguration();
        }
    }

    static int getConfigInt(String key, int def) {
        return configuration.get("general", key, def, StringHelper.localize(Lang.getLangConfigValue(key))).getInt(def);
    }

    static boolean getConfigBool(String key, boolean def) {
        return configuration.get("general", key, def, StringHelper.localize(Lang.getLangConfigValue(key))).getBoolean(def);
    }

    static void loadConfiguration() {
        int i;
        Settings.sampleSize = ConfigHandler.getConfigInt("globalSampleSize", 500);
        Settings.learnTicks = ConfigHandler.getConfigInt("globalLearnTicks", 20);
        Settings.strictFactorySpawns = ConfigHandler.getConfigBool("globalStrictSpawns", false);
        Settings.strictPower = ConfigHandler.getConfigBool("globalStrictPower", false);
        Settings.tierIRFtick = ConfigHandler.getConfigInt("globalTierIRF", 80);
        Settings.tierIIRFtick = ConfigHandler.getConfigInt("globalTierIIRF", 160);
        Settings.tierIIIRFtick = ConfigHandler.getConfigInt("globalTierIIIRF", 240);
        Settings.tierIVRFtick = ConfigHandler.getConfigInt("globalTierIVRF", 320);
        Settings.xpRFtick = ConfigHandler.getConfigInt("globalXpRF", 16);
        Settings.baseMobCount = ConfigHandler.getConfigInt("globalBaseMobCount", 1);
        Settings.baseRateTicks = ConfigHandler.getConfigInt("globalBaseRateTicks", 320);
        Settings.tierIMobXpCap = ConfigHandler.getConfigInt("globalTierIMobXpCap", 5);
        Settings.tierIIMobXpCap = ConfigHandler.getConfigInt("globalTierIIMobXpCap", 20);
        Settings.tierIIIMobXpCap = ConfigHandler.getConfigInt("globalTierIIIMobXpCap", 49);
        Settings.tierIVMobXpCap = ConfigHandler.getConfigInt("globalTierIVMobXpCap", 65535);
        Settings.prismBlacklist = configuration.getStringList("globalPrismBlacklist", "general", Settings.Progression.DEF_PRISM_BLACKLIST, StringHelper.localize(Lang.getLangConfigValue("globalPrismBlacklist")));
        Settings.prismWhitelist = configuration.getStringList("globalPrismWhitelist", "general", Settings.Progression.DEF_PRISM_WHITELIST, StringHelper.localize(Lang.getLangConfigValue("globalPrismWhitelist")));
        Settings.usePrismWhitelist = ConfigHandler.getConfigBool("globalPrismUseWhitelist", false);
        if (Settings.usePrismWhitelist) {
            for (i = 0; i < Settings.prismWhitelist.length; ++i) {
                LogHelper.info("Using Prism Whitelist: " + Settings.prismWhitelist[i]);
            }
        } else {
            for (i = 0; i < Settings.prismBlacklist.length; ++i) {
                LogHelper.info("Using Prism Blacklist: " + Settings.prismBlacklist[i]);
            }
        }
        Settings.tierIMobs = configuration.getStringList("globalTierIMobList", "general", Settings.Progression.DEF_TIER_I_MOBS, StringHelper.localize(Lang.getLangConfigValue("globalTierIMobList")));
        Settings.tierIIMobs = configuration.getStringList("globalTierIIMobList", "general", Settings.Progression.DEF_TIER_II_MOBS, StringHelper.localize(Lang.getLangConfigValue("globalTierIIMobList")));
        Settings.tierIIIMobs = configuration.getStringList("globalTierIIIMobList", "general", Settings.Progression.DEF_TIER_III_MOBS, StringHelper.localize(Lang.getLangConfigValue("globalTierIIIMobList")));
        Settings.tierIVMobs = configuration.getStringList("globalTierIVMobList", "general", Settings.Progression.DEF_TIER_IV_MOBS, StringHelper.localize(Lang.getLangConfigValue("globalTierIVMobList")));
        for (i = 0; i < Settings.tierIMobs.length; ++i) {
            Woot.tierMapper.addMapping(Settings.tierIMobs[i], EnumMobFactoryTier.TIER_ONE);
        }
        for (i = 0; i < Settings.tierIIMobs.length; ++i) {
            Woot.tierMapper.addMapping(Settings.tierIIMobs[i], EnumMobFactoryTier.TIER_TWO);
        }
        for (i = 0; i < Settings.tierIIIMobs.length; ++i) {
            Woot.tierMapper.addMapping(Settings.tierIIIMobs[i], EnumMobFactoryTier.TIER_THREE);
        }
        for (i = 0; i < Settings.tierIVMobs.length; ++i) {
            Woot.tierMapper.addMapping(Settings.tierIVMobs[i], EnumMobFactoryTier.TIER_FOUR);
        }
        Settings.dropBlacklist = configuration.getStringList("globalDropBlacklist", "general", Settings.dropBlacklist, StringHelper.localize(Lang.getLangConfigValue("globalDropBlacklist")));
        for (i = 0; i < Settings.dropBlacklist.length; ++i) {
            Woot.LOOT_TABLE_MANAGER.addToBlacklist(Settings.dropBlacklist[i]);
        }
        Settings.spawnCostList = configuration.getStringList("globalSpawnCostList", "general", Settings.Progression.DEF_SPAWN_COST, StringHelper.localize(Lang.getLangConfigValue("globalSpawnCostList")));
        for (i = 0; i < Settings.spawnCostList.length; ++i) {
            String[] parts = Settings.spawnCostList[i].split("=");
            if (parts.length == 2) {
                try {
                    int cost = Integer.parseInt(parts[1]);
                    Woot.mobRegistry.addCosting(parts[0], cost);
                    LogHelper.info("Adding mob cost: " + parts[0] + "=" + cost);
                }
                catch (NumberFormatException e) {
                    LogHelper.error("Invalid mob cost: " + Settings.spawnCostList[i]);
                }
                continue;
            }
            LogHelper.error("Invalid mob cost: " + Settings.spawnCostList[i]);
        }
        Settings.rateIRfTick = ConfigHandler.getConfigInt("rateI_RFTick", 80);
        Settings.rateIIRfTick = ConfigHandler.getConfigInt("rateII_RFTick", 160);
        Settings.rateIIIRfTick = ConfigHandler.getConfigInt("rateIII_RFTick", 240);
        Settings.lootingIRfTick = ConfigHandler.getConfigInt("lootingI_RFTick", 80);
        Settings.lootingIIRfTick = ConfigHandler.getConfigInt("lootingII_RFTick", 160);
        Settings.lootingIIIRfTick = ConfigHandler.getConfigInt("lootingIII_RFTick", 240);
        Settings.xpIRfTick = ConfigHandler.getConfigInt("xpI_RFTick", 80);
        Settings.xpIIRfTick = ConfigHandler.getConfigInt("xpII_RFTick", 160);
        Settings.xpIIIRfTick = ConfigHandler.getConfigInt("xpIII_RFTick", 240);
        Settings.massIRfTick = ConfigHandler.getConfigInt("massI_RFTick", 80);
        Settings.massIIRfTick = ConfigHandler.getConfigInt("massII_RFTick", 160);
        Settings.massIIIRfTick = ConfigHandler.getConfigInt("massIII_RFTick", 240);
        Settings.decapitateIRfTick = ConfigHandler.getConfigInt("decapI_RFTick", 80);
        Settings.decapitateIIRfTick = ConfigHandler.getConfigInt("decapII_RFTick", 160);
        Settings.decapitateIIIRfTick = ConfigHandler.getConfigInt("decapIII_RFTick", 240);
        Settings.bmIRfTick = ConfigHandler.getConfigInt("bmI_RFTick", 80);
        Settings.bmIIRfTick = ConfigHandler.getConfigInt("bmII_RFTick", 160);
        Settings.bmIIIRfTick = ConfigHandler.getConfigInt("bmIII_RFTick", 240);
        Settings.lootingILevel = ConfigHandler.getConfigInt("lootingI_enchantLevel", 1);
        Settings.lootingIILevel = ConfigHandler.getConfigInt("lootingII_enchantLevel", 2);
        Settings.lootingIIILevel = ConfigHandler.getConfigInt("lootingIII_enchantLevel", 3);
        Settings.rateITicks = ConfigHandler.getConfigInt("rateI_ticks", 160);
        Settings.rateIITicks = ConfigHandler.getConfigInt("rateII_ticks", 80);
        Settings.rateIIITicks = ConfigHandler.getConfigInt("rateIII_ticks", 40);
        Settings.massIMobs = ConfigHandler.getConfigInt("massI_mobCount", 4);
        Settings.massIIMobs = ConfigHandler.getConfigInt("massII_mobCount", 6);
        Settings.massIIIMobs = ConfigHandler.getConfigInt("massIII_mobCount", 8);
        Settings.decapitateIChance = ConfigHandler.getConfigInt("decapI_percentage", 20);
        Settings.decapitateIIChance = ConfigHandler.getConfigInt("decapII_percentage", 40);
        Settings.decapitateIIIChance = ConfigHandler.getConfigInt("decapIII_percentage", 80);
        Settings.xpIBoost = ConfigHandler.getConfigInt("xpI_boost", 20);
        Settings.xpIIBoost = ConfigHandler.getConfigInt("xpII_boost", 40);
        Settings.xpIIIBoost = ConfigHandler.getConfigInt("xpIII_boost", 80);
        Settings.efficiencyI = ConfigHandler.getConfigInt("efficiencyI_percentage", 15);
        Settings.efficiencyII = ConfigHandler.getConfigInt("efficiencyII_percentage", 25);
        Settings.efficiencyIII = ConfigHandler.getConfigInt("efficiencyIII_percentage", 30);
        Settings.bmICount = ConfigHandler.getConfigInt("bmI_count", 10);
        Settings.bmIICount = ConfigHandler.getConfigInt("bmII_count", 20);
        Settings.bmIIICount = ConfigHandler.getConfigInt("bmIII_count", 30);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("Woot")) {
            ConfigHandler.loadConfiguration();
        }
    }
}

