/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.manager;

import cofh.api.energy.EnergyStorage;
import ipsis.woot.tileentity.TileEntityMobFactory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class PowerManager {
    static final int MAX_RF_TICK = 32000;
    static final int RF_STORED = 10000000;
    protected EnergyStorage energyStorage = new EnergyStorage(10000000, 32000);
    private TileEntityMobFactory factory;

    public PowerManager(TileEntityMobFactory factory) {
        this.factory = factory;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        this.energyStorage.writeToNBT(compound);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.energyStorage.readFromNBT(compound);
    }

    public boolean isValidFrom(EnumFacing from, boolean isFactory) {
        if (isFactory) {
            return from == EnumFacing.DOWN;
        }
        return this.factory.getProxyManager().validProxy && from != EnumFacing.UP;
    }

    public int extractEnergy(int rfpertick, boolean simulate) {
        return this.energyStorage.extractEnergy(rfpertick, simulate);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate, boolean isFactory) {
        if (this.isValidFrom(from, isFactory)) {
            return this.energyStorage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int getEnergyStored(EnumFacing from, boolean isFactory) {
        if (this.isValidFrom(from, isFactory)) {
            return this.energyStorage.getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(EnumFacing from, boolean isFactory) {
        if (this.isValidFrom(from, isFactory)) {
            return this.energyStorage.getMaxEnergyStored();
        }
        return 0;
    }

    public boolean canConnectEnergy(EnumFacing from, boolean isFactory) {
        return this.isValidFrom(from, isFactory);
    }
}

