/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.plugins.waila;

import ipsis.Woot;
import ipsis.woot.block.BlockMobFactory;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.manager.EnumSpawnerUpgrade;
import ipsis.woot.manager.SpawnerUpgrade;
import ipsis.woot.manager.UpgradeManager;
import ipsis.woot.tileentity.TileEntityMobFactory;
import ipsis.woot.tileentity.TileEntityMobFactoryController;
import ipsis.woot.tileentity.TileEntityMobFactoryStructure;
import ipsis.woot.tileentity.TileEntityMobFactoryUpgrade;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryTier;
import ipsis.woot.util.StringHelper;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class WailaDataProviderWoot
implements IWailaDataProvider {
    private static WailaDataProviderWoot INSTANCE = new WailaDataProviderWoot();

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (block == ModBlocks.blockStructure) {
            int meta = accessor.getMetadata();
            return new ItemStack((Block)ModBlocks.blockStructure, 1, meta);
        }
        if (block == ModBlocks.blockUpgrade) {
            int meta = accessor.getMetadata();
            return new ItemStack((Block)ModBlocks.blockUpgrade, 1, meta);
        }
        if (block == ModBlocks.blockUpgradeB) {
            int meta = accessor.getMetadata();
            return new ItemStack((Block)ModBlocks.blockUpgradeB, 1, meta);
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getTileEntity() instanceof TileEntityMobFactory) {
            return this.getWailaBodyFactory(itemStack, currenttip, accessor, config);
        }
        if (accessor.getTileEntity() instanceof TileEntityMobFactoryController) {
            return this.getWailaBodyController(itemStack, currenttip, accessor, config);
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof TileEntityMobFactory) {
            return this.getNBTDataFactory(player, te, tag, world, pos);
        }
        if (te instanceof TileEntityMobFactoryController) {
            return this.getNBTDataController(player, te, tag, world, pos);
        }
        return tag;
    }

    public List<String> getWailaBodyController(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("displayName") && tag.func_74764_b("tier")) {
            EnumMobFactoryTier t = EnumMobFactoryTier.getTier(tag.func_74771_c("tier"));
            currenttip.add(TextFormatting.GREEN + tag.func_74779_i("displayName"));
            currenttip.add(TextFormatting.BLUE + String.format(t.getTranslated("waila.Woot:controller.tier"), new Object[0]));
        }
        return currenttip;
    }

    public NBTTagCompound getNBTDataController(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        TileEntityMobFactoryController controller = (TileEntityMobFactoryController)te;
        String displayName = controller.getModDisplayName();
        if (!displayName.equals("")) {
            tag.func_74778_a("displayName", displayName);
        }
        tag.func_74774_a("tier", (byte)Woot.tierMapper.getTierForEntity(controller.getMobName(), controller.getXpValue()).ordinal());
        return tag;
    }

    public List<String> getWailaBodyFactory(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("displayName")) {
            BlockMobFactory.PluginTooltipInfo info = BlockMobFactory.PluginTooltipInfo.fromNBT(tag);
            currenttip.add(TextFormatting.BLUE + String.format(info.tier.getTranslated("waila.Woot:factory.tier"), new Object[0]));
            currenttip.add(TextFormatting.GREEN + String.format(StringHelper.localize("waila.Woot:factory.mob"), info.displayName));
            currenttip.add(TextFormatting.GREEN + String.format(StringHelper.localize("waila.Woot:factory.rate"), info.maxMass, info.spawnTime));
            currenttip.add(TextFormatting.GREEN + String.format(StringHelper.localize("waila.Woot:factory.cost"), info.spawnRF, info.spawnTickRF));
            if (info.isRunning) {
                currenttip.add(TextFormatting.GREEN + String.format(StringHelper.localize("waila.Woot:factory.running"), new Object[0]));
            } else {
                currenttip.add(TextFormatting.RED + String.format(StringHelper.localize("waila.Woot:factory.stopped"), new Object[0]));
            }
            currenttip.add(TextFormatting.RED + String.format("%d / %d RF", info.storedRF, info.totalRF));
            if (accessor.getPlayer().func_70093_af()) {
                if (tag.func_74764_b("upgrades")) {
                    byte[] a = tag.func_74770_j("upgrades");
                    for (int i = 0; i < a.length; ++i) {
                        EnumSpawnerUpgrade e = EnumSpawnerUpgrade.getFromMetadata(a[i]);
                        SpawnerUpgrade u = UpgradeManager.getSpawnerUpgrade(e);
                        TextFormatting f = u.getUpgradeTier() == 1 ? TextFormatting.GRAY : (u.getUpgradeTier() == 2 ? TextFormatting.GOLD : TextFormatting.AQUA);
                        currenttip.add(f + StringHelper.localize("tooltip.Woot:upgrade." + (Object)((Object)EnumSpawnerUpgrade.getFromMetadata(a[i]))));
                    }
                } else {
                    currenttip.add(StringHelper.localize("waila.Woot:factory.nullupgrades"));
                }
            } else {
                currenttip.add(StringHelper.localize("waila.Woot:factory.sneak"));
            }
        }
        return currenttip;
    }

    public NBTTagCompound getNBTDataFactory(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        TileEntityMobFactory tile = (TileEntityMobFactory)te;
        if (tile.isFormed()) {
            List<EnumSpawnerUpgrade> upgradeList;
            BlockMobFactory.PluginTooltipInfo info = new BlockMobFactory.PluginTooltipInfo(tile);
            info.toNBT(tag);
            if (tile.getUpgradeSetup() != null && !(upgradeList = tile.getUpgradeSetup().getUpgradeList()).isEmpty()) {
                byte[] u = new byte[upgradeList.size()];
                int i = 0;
                for (EnumSpawnerUpgrade upgrade : upgradeList) {
                    u[i] = (byte)upgrade.ordinal();
                    ++i;
                }
                tag.func_74782_a("upgrades", (NBTBase)new NBTTagByteArray(u));
            }
        }
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, TileEntityMobFactoryStructure.class);
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, TileEntityMobFactoryUpgrade.class);
        registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, TileEntityMobFactory.class);
        registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, TileEntityMobFactoryController.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, TileEntityMobFactory.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, TileEntityMobFactoryController.class);
    }
}

