/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.tileentity;

import cofh.api.energy.IEnergyReceiver;
import ipsis.Woot;
import ipsis.woot.block.BlockMobFactory;
import ipsis.woot.init.ModItems;
import ipsis.woot.manager.ControllerConfig;
import ipsis.woot.manager.EnumEnchantKey;
import ipsis.woot.manager.PowerManager;
import ipsis.woot.manager.ProxyManager;
import ipsis.woot.manager.SpawnerManager;
import ipsis.woot.manager.SpawnerUpgrade;
import ipsis.woot.manager.UpgradeManager;
import ipsis.woot.manager.UpgradeSetup;
import ipsis.woot.plugins.bloodmagic.BloodMagic;
import ipsis.woot.reference.Settings;
import ipsis.woot.tileentity.TileEntityMobFactoryStructure;
import ipsis.woot.tileentity.TileEntityMobFactoryUpgrade;
import ipsis.woot.tileentity.multiblock.EnumMobFactoryTier;
import ipsis.woot.tileentity.multiblock.MobFactoryMultiblockLogic;
import ipsis.woot.util.BlockPosHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityMobFactory
extends TileEntity
implements ITickable,
IEnergyReceiver {
    EnumMobFactoryTier factoryTier = null;
    SpawnerManager.SpawnReq spawnReq = null;
    boolean nbtLoaded = false;
    UpgradeSetup upgradeSetup;
    ControllerConfig controllerConfig;
    AxisAlignedBB bb;
    ProxyManager proxyManager;
    int currLearnTicks = 0;
    int currSpawnTicks = 0;
    int consumedRf = 0;
    int storedXp = 0;
    int learnTicksOffset;
    boolean running = true;
    int structureTicks = 0;
    boolean dirtyStructure = true;
    boolean dirtyUpgrade = false;
    boolean dirtyProxy;
    List<BlockPos> structureBlockList = new ArrayList<BlockPos>();
    List<BlockPos> upgradeBlockList = new ArrayList<BlockPos>();
    static final String NBT_CURR_SPAWN_TICK = "spawnTicks";
    static final String NBT_CONSUMED_RF = "consumedRf";
    static final String NBT_STORED_XP = "storedXp";
    static final String NBT_RUNNING = "running";
    static final int MULTIBLOCK_BACKOFF_SCAN_TICKS = 20;
    private boolean bmKeepAlive = false;
    protected PowerManager powerManager = new PowerManager(this);

    void setCurrSpawnTicks(int ticks) {
        if (this.currSpawnTicks != ticks) {
            this.currSpawnTicks = ticks;
            this.func_70296_d();
        }
    }

    void incCurrSpawnTicks() {
        ++this.currSpawnTicks;
        this.func_70296_d();
    }

    void setConsumedRf(int rf) {
        if (this.consumedRf != rf) {
            this.consumedRf = rf;
            this.func_70296_d();
        }
    }

    void setStoredXp(int xp) {
        if (this.storedXp != xp) {
            this.storedXp = xp;
            this.func_70296_d();
        }
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.isFormed()) {
            return compound;
        }
        compound.func_74768_a(NBT_CURR_SPAWN_TICK, this.currSpawnTicks);
        compound.func_74768_a(NBT_CONSUMED_RF, this.consumedRf);
        compound.func_74768_a(NBT_STORED_XP, this.storedXp);
        compound.func_74757_a(NBT_RUNNING, this.running);
        this.powerManager.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_CURR_SPAWN_TICK)) {
            this.currSpawnTicks = compound.func_74762_e(NBT_CURR_SPAWN_TICK);
            this.consumedRf = compound.func_74762_e(NBT_CONSUMED_RF);
            this.storedXp = compound.func_74762_e(NBT_STORED_XP);
            this.running = compound.func_74764_b(NBT_RUNNING) ? compound.func_74767_n(NBT_RUNNING) : true;
            this.nbtLoaded = true;
        }
        this.powerManager.readFromNBT(compound);
    }

    public TileEntityMobFactory() {
        this.upgradeSetup = new UpgradeSetup();
        this.controllerConfig = new ControllerConfig();
        this.proxyManager = new ProxyManager(this);
        this.learnTicksOffset = Settings.learnTicks + Woot.RANDOM.nextInt(11);
    }

    public String getMobName() {
        return this.controllerConfig.getMobName();
    }

    public String getMobDisplayName() {
        return this.controllerConfig.getDisplayName();
    }

    public SpawnerManager.SpawnReq getSpawnReq() {
        return this.spawnReq;
    }

    public EnumMobFactoryTier getFactoryTier() {
        return this.factoryTier;
    }

    public UpgradeSetup getUpgradeSetup() {
        return this.upgradeSetup;
    }

    void setRunning(boolean running) {
        if (this.running != running) {
            this.running = running;
            this.func_70296_d();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isFormed() {
        return this.factoryTier != null && Woot.mobRegistry.isValidMobName(this.controllerConfig.getMobName()) && this.spawnReq != null;
    }

    void updateStructureBlocks(boolean connected) {
        for (BlockPos p : this.structureBlockList) {
            TileEntity te;
            if (!this.field_145850_b.func_175667_e(p) || !((te = this.field_145850_b.func_175625_s(p)) instanceof TileEntityMobFactoryStructure)) continue;
            if (connected) {
                ((TileEntityMobFactoryStructure)te).setMaster(this);
                continue;
            }
            ((TileEntityMobFactoryStructure)te).clearMaster();
        }
    }

    void updateUpgradeBlocks(boolean connected) {
        for (BlockPos p : this.upgradeBlockList) {
            TileEntity te;
            if (!this.field_145850_b.func_175667_e(p) || !((te = this.field_145850_b.func_175625_s(p)) instanceof TileEntityMobFactoryUpgrade)) continue;
            if (connected) {
                ((TileEntityMobFactoryUpgrade)te).setMaster(this);
                continue;
            }
            ((TileEntityMobFactoryUpgrade)te).clearMaster();
        }
    }

    void onStructureCheck() {
        EnumMobFactoryTier oldFactoryTier = this.factoryTier;
        MobFactoryMultiblockLogic.FactorySetup factorySetup = MobFactoryMultiblockLogic.validateFactory(this);
        if (factorySetup.getSize() == null) {
            this.updateStructureBlocks(false);
            this.updateUpgradeBlocks(false);
            this.proxyManager.setMaster(false);
            this.factoryTier = factorySetup.getSize();
            this.controllerConfig.clearMobName();
            return;
        }
        if (oldFactoryTier != this.factoryTier) {
            this.updateStructureBlocks(false);
        }
        this.factoryTier = factorySetup.getSize();
        this.controllerConfig.setMobName(factorySetup.getMobName(), factorySetup.getDisplayName());
        this.structureBlockList = factorySetup.getBlockPosList();
        this.updateStructureBlocks(true);
        this.onUpgradeCheck();
        this.onProxyCheck();
    }

    void onUpgradeCheck() {
        this.updateUpgradeBlocks(false);
        this.upgradeSetup.clear();
        this.upgradeBlockList.clear();
        if (this.factoryTier == EnumMobFactoryTier.TIER_ONE) {
            this.upgradeTier1();
        } else if (this.factoryTier == EnumMobFactoryTier.TIER_TWO) {
            this.upgradeTier2();
        } else if (this.factoryTier == EnumMobFactoryTier.TIER_THREE || this.factoryTier == EnumMobFactoryTier.TIER_FOUR) {
            this.upgradeTier3();
        }
        this.spawnReq = Woot.spawnerManager.getSpawnReq(this.controllerConfig.getMobName(), this.upgradeSetup, this, this.factoryTier);
        if (this.nbtLoaded) {
            this.nbtLoaded = false;
        } else {
            this.setConsumedRf(0);
            this.setCurrSpawnTicks(0);
        }
        this.updateUpgradeBlocks(true);
    }

    void onProxyCheck() {
        this.proxyManager.setMaster(false);
        this.proxyManager.scanProxy();
    }

    public void manualValidate(EntityPlayer player) {
        MobFactoryMultiblockLogic.FactorySetup factorySetup = MobFactoryMultiblockLogic.validateFactory(this, true, player);
    }

    void upgradeTierX(BlockPos[] upgradePos, int maxTier) {
        ArrayList<SpawnerUpgrade> tmpUpgradeList = new ArrayList<SpawnerUpgrade>();
        EnumFacing f = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMobFactory.FACING);
        for (BlockPos p : upgradePos) {
            BlockPos offset = BlockPosHelper.rotateFromSouth(p, f.func_176734_d());
            BlockPos p2 = this.func_174877_v().func_177982_a(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
            UpgradeManager.scanUpgradeTotem(this.field_145850_b, p2, maxTier, tmpUpgradeList, this.upgradeBlockList);
        }
        this.upgradeSetup.processUpgrades(tmpUpgradeList);
    }

    void upgradeTier1() {
        BlockPos[] upgradePos = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0)};
        this.upgradeTierX(upgradePos, 1);
    }

    void upgradeTier2() {
        BlockPos[] upgradePos = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(-2, 0, 0)};
        this.upgradeTierX(upgradePos, 2);
    }

    void upgradeTier3() {
        BlockPos[] upgradePos = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(-2, 0, 0)};
        this.upgradeTierX(upgradePos, 3);
    }

    private boolean isMachinePowered() {
        boolean controller = this.field_145850_b.func_175640_z(this.field_174879_c);
        boolean proxy = this.proxyManager.isBlockPowered();
        return controller || proxy;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.structureTicks;
        if (this.dirtyStructure && this.structureTicks >= 20) {
            this.onStructureCheck();
            this.dirtyStructure = false;
            this.dirtyUpgrade = false;
        }
        if (this.dirtyUpgrade && this.structureTicks >= 20) {
            this.onUpgradeCheck();
            this.dirtyUpgrade = false;
        }
        if (this.dirtyProxy) {
            this.onProxyCheck();
            this.dirtyProxy = false;
        }
        if (this.structureTicks >= 20) {
            this.structureTicks = 0;
        }
        boolean powered = this.isMachinePowered();
        if (this.running && powered) {
            this.setRunning(false);
        } else if (!this.running && !powered) {
            this.setRunning(true);
        }
        if (!this.isFormed()) {
            return;
        }
        this.tryPickupModItems();
        ++this.currLearnTicks;
        if (this.currLearnTicks >= this.learnTicksOffset) {
            if (!Woot.LOOT_TABLE_MANAGER.isFull(this.controllerConfig.getMobName(), this.upgradeSetup.getEnchantKey())) {
                BlockPos spawnPos = new BlockPos(this.func_174877_v().func_177958_n(), 0, this.func_174877_v().func_177952_p());
                Woot.spawnerManager.spawn(this.controllerConfig.getMobName(), this.upgradeSetup.getEnchantKey(), this.field_145850_b, this.func_174877_v());
            }
            this.currLearnTicks = 0;
        }
        if (Woot.LOOT_TABLE_MANAGER.isEmpty(this.controllerConfig.getMobName(), this.upgradeSetup.getEnchantKey())) {
            return;
        }
        if (this.running) {
            this.incCurrSpawnTicks();
            this.processPower();
            if (this.currSpawnTicks >= this.spawnReq.getSpawnTime()) {
                this.onSpawn();
                this.setCurrSpawnTicks(0);
            }
        }
    }

    private void tryPickupModItems() {
        EnumEnchantKey key = this.upgradeSetup.getEnchantKey();
        String mobName = this.controllerConfig.getMobName();
        if (!Woot.LOOT_TABLE_MANAGER.isFull(mobName, key)) {
            List itemList;
            if (this.bb == null) {
                BlockPos checkPos = new BlockPos(this.func_174877_v().func_177958_n(), 1, this.func_174877_v().func_177952_p());
                int range = 2;
                this.bb = new AxisAlignedBB(checkPos).func_72314_b((double)range, 0.0, (double)range);
            }
            if (!(itemList = this.field_145850_b.func_175647_a(EntityItem.class, this.bb, EntitySelectors.field_94557_a)).isEmpty()) {
                Woot.LOOT_TABLE_MANAGER.update(mobName, key, itemList, false);
                for (EntityItem i : itemList) {
                    i.func_70106_y();
                }
            }
        }
    }

    public void interruptStructure() {
        this.dirtyStructure = true;
    }

    public void interruptUpgrade() {
        this.dirtyUpgrade = true;
    }

    public void interruptProxy() {
        this.dirtyProxy = true;
    }

    void processPower() {
        int drawnRf = this.powerManager.extractEnergy(this.spawnReq.getRfPerTick(), false);
        if (Woot.devMode) {
            drawnRf = this.spawnReq.getRfPerTick();
        }
        if (drawnRf == this.spawnReq.getRfPerTick()) {
            this.setConsumedRf(this.consumedRf + drawnRf);
        } else if (Settings.strictPower) {
            this.setConsumedRf(0);
        } else {
            this.setConsumedRf(this.consumedRf + drawnRf);
        }
    }

    private void bmOutput(UpgradeSetup upgradeSetup) {
        TileEntity te;
        if (!upgradeSetup.hasBmUpgrade()) {
            return;
        }
        if (!this.bmKeepAlive || BloodMagic.fluidOutput == null) {
            return;
        }
        ArrayList<Object> validHandlers = new ArrayList<Object>();
        EnumFacing f = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMobFactory.FACING);
        if (this.field_145850_b.func_175667_e(this.func_174877_v().func_177972_a(f)) && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f))) != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d())) {
            validHandlers.add(te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d()));
        }
        validHandlers.addAll(this.proxyManager.getIFluidHandlers());
        int mobCount = 1;
        if (upgradeSetup.hasMassUpgrade()) {
            mobCount = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getMassUpgrade()).getMass();
        }
        int upgradeSacrificeCount = UpgradeManager.getSpawnerUpgrade(upgradeSetup.getBmUpgrade()).getSacrificeCount();
        float sacrificeEfficiencyMultiplier = (float)(0.1 * (double)upgradeSacrificeCount);
        int amount = (int)((1.0f + sacrificeEfficiencyMultiplier) * 20.0f) * mobCount;
        FluidStack out = new FluidStack(BloodMagic.fluidOutput, amount);
        for (IFluidHandler iFluidHandler : validHandlers) {
            if (out.amount == 0) break;
            int result = iFluidHandler.fill(out, true);
            out.amount -= result;
            if (out.amount >= 0) continue;
            out.amount = 0;
        }
        this.bmKeepAlive = false;
    }

    private void produceOutput() {
        TileEntity te;
        SpawnerManager.SpawnLoot loot = Woot.spawnerManager.getSpawnerLoot(this.controllerConfig.getMobName(), this.upgradeSetup, this.field_145850_b.func_175649_E(this.func_174877_v()));
        ArrayList<Object> validHandlers = new ArrayList<Object>();
        EnumFacing f = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMobFactory.FACING);
        if (this.field_145850_b.func_175667_e(this.func_174877_v().func_177972_a(f)) && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f))) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d())) {
            validHandlers.add(te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d()));
        }
        validHandlers.addAll(this.proxyManager.getIItemHandlers());
        this.bmOutput(this.upgradeSetup);
        for (IItemHandler iItemHandler : validHandlers) {
            for (ItemStack itemStack : loot.getDropList()) {
                ItemStack result;
                if (itemStack.field_77994_a <= 0 || (result = ItemHandlerHelper.insertItem((IItemHandler)iItemHandler, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1), (boolean)false)) != null) continue;
                --itemStack.field_77994_a;
            }
            this.storedXp += loot.getXp();
            int c = this.storedXp / 16;
            if (c == 0) continue;
            ItemStack xpShards = new ItemStack((Item)ModItems.itemXpShard);
            ItemHandlerHelper.insertItem((IItemHandler)iItemHandler, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)xpShards, (int)c), (boolean)false);
            this.storedXp -= c * 16;
        }
    }

    void onSpawn() {
        if (this.consumedRf >= this.spawnReq.getTotalRf()) {
            this.produceOutput();
            this.setConsumedRf(0);
        } else if (Settings.strictPower) {
            this.setConsumedRf(0);
        }
    }

    public void func_145843_s() {
        this.updateStructureBlocks(false);
        this.updateUpgradeBlocks(false);
        this.proxyManager.setMaster(false);
        super.func_145843_s();
    }

    public void bmKeepAlive() {
        this.bmKeepAlive = true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.isFormed()) {
            return 0;
        }
        return this.powerManager.receiveEnergy(from, maxReceive, simulate, true);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        if (!this.isFormed()) {
            return 0;
        }
        return this.powerManager.getEnergyStored(from, true);
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        if (!this.isFormed()) {
            return 0;
        }
        return this.powerManager.getMaxEnergyStored(from, true);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        if (!this.isFormed()) {
            return false;
        }
        return this.powerManager.canConnectEnergy(from, true);
    }
}

