/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.tileentity;

import ipsis.woot.tileentity.TileEntityMobFactory;
import ipsis.woot.util.WorldHelper;
import java.util.ArrayList;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileEntityMobFactoryStructure
extends TileEntity {
    TileEntityMobFactory master = null;
    boolean isClientFormed;

    public boolean hasMaster() {
        return this.master != null;
    }

    public void clearMaster() {
        if (this.master != null) {
            this.master = null;
            WorldHelper.updateClient(this.func_145831_w(), this.func_174877_v());
        }
    }

    public void setMaster(TileEntityMobFactory master) {
        if (this.master != master) {
            this.master = master;
            WorldHelper.updateClient(this.func_145831_w(), this.func_174877_v());
        }
    }

    TileEntityMobFactory findMaster() {
        ArrayList<TileEntityMobFactoryStructure> connectedTEs = new ArrayList<TileEntityMobFactoryStructure>();
        Stack<TileEntityMobFactoryStructure> traversingTEs = new Stack<TileEntityMobFactoryStructure>();
        TileEntityMobFactory tmpMaster = null;
        boolean masterFound = false;
        traversingTEs.add(this);
        while (!masterFound && !traversingTEs.isEmpty()) {
            TileEntityMobFactoryStructure currTE = (TileEntityMobFactoryStructure)((Object)traversingTEs.pop());
            connectedTEs.add(currTE);
            for (EnumFacing f : EnumFacing.values()) {
                TileEntity te = this.field_145850_b.func_175625_s(currTE.func_174877_v().func_177972_a(f));
                if (te instanceof TileEntityMobFactoryStructure && !connectedTEs.contains(te)) {
                    traversingTEs.add((TileEntityMobFactoryStructure)te);
                    continue;
                }
                if (!(te instanceof TileEntityMobFactory)) continue;
                masterFound = true;
                tmpMaster = (TileEntityMobFactory)te;
            }
        }
        return tmpMaster;
    }

    public void blockAdded() {
        TileEntityMobFactory tmpMaster = this.findMaster();
        if (tmpMaster != null) {
            tmpMaster.interruptStructure();
        }
    }

    public void func_145843_s() {
        if (this.hasMaster()) {
            this.master.interruptStructure();
        }
    }

    public boolean isClientFormed() {
        return this.isClientFormed;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("formed", this.master != null);
        return nbtTagCompound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.isClientFormed = tag.func_74767_n("formed");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
        WorldHelper.updateClient(this.func_145831_w(), this.func_174877_v());
    }
}

