/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import ipsis.woot.manager.loot.Drop;
import ipsis.woot.manager.loot.LootPool;
import ipsis.woot.manager.loot.LootTable;
import ipsis.woot.oss.LogHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;

public class SerializationHelper {
    public static final Type LOOT_MAP_TYPE = new TypeToken<HashMap<String, LootTable>>(){}.getType();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(Drop.class, (Object)new Drop.Serializer()).registerTypeAdapter(Drop.DropData.class, (Object)new Drop.DropData.Serializer()).create();

    public static void writeHashMapToFile(HashMap<String, LootTable> map, File file) {
        SerializationHelper.writeJsonFile(file, GSON.toJson(map, LOOT_MAP_TYPE));
    }

    public static HashMap<String, LootTable> readHashMapFromFile(File file) throws FileNotFoundException {
        HashMap map = new HashMap();
        try {
            map = (HashMap)GSON.fromJson(SerializationHelper.readJsonFile(file), LOOT_MAP_TYPE);
        }
        catch (JsonParseException e) {
            LogHelper.warn("Failed to load loot table from '" + file.toString() + "' " + e.getMessage());
            map = new HashMap();
        }
        return map;
    }

    private static String readJsonFile(File file) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        if (file != null) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    throw (FileNotFoundException)e;
                }
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    private static void writeJsonFile(File file, String data) {
        if (file == null) {
            return;
        }
        file.getParentFile().mkdirs();
        File tmpFile = new File(file.getAbsolutePath() + "_tmp");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));){
            writer.write(data);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (file.exists()) {
            file.delete();
        }
        if (!file.exists()) {
            tmpFile.renameTo(file);
        }
    }
}

