/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gearswap.blocks;

import java.util.ArrayList;
import java.util.List;
import mcjty.gearswap.GearSwap;
import mcjty.gearswap.blocks.GearSwapperTE;
import mcjty.gearswap.compat.top.TOPInfoProvider;
import mcjty.gearswap.compat.waila.WailaInfoProvider;
import mcjty.gearswap.network.PacketHandler;
import mcjty.gearswap.network.PacketRememberSetup;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GearSwapperBlock
extends Block
implements ITileEntityProvider,
WailaInfoProvider,
TOPInfoProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public GearSwapperBlock(Material material, String blockName) {
        super(material);
        this.func_149663_c(blockName);
        this.setRegistryName(blockName);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public TileEntity func_149915_a(World world, int i) {
        return new GearSwapperTE();
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        list.add("This block can remember four different sets of tools, weapons");
        list.add("and armor and allows you to quickly switch between them.");
        list.add("Sneak-left-click to store current hotbar+armor in slot.");
        list.add("Right-click on slot to restore hotbar+armor.");
        list.add("Right-click on bottom to open GUI.");
    }

    public static int getSlot(RayTraceResult mouseOver, World world) {
        return GearSwapperBlock.getSlot(world, mouseOver.func_178782_a(), mouseOver.field_178784_b, mouseOver.field_72307_f);
    }

    public static int getSlot(World world, BlockPos blockPos, EnumFacing sideHit, Vec3d hitVec) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        EnumFacing k = GearSwapperBlock.getOrientation((IBlockAccess)world, blockPos);
        if (sideHit == k) {
            float sx = (float)(hitVec.field_72450_a - (double)x);
            float sy = (float)(hitVec.field_72448_b - (double)y);
            float sz = (float)(hitVec.field_72449_c - (double)z);
            return GearSwapperBlock.calculateHitIndex(sx, sy, sz, k);
        }
        return -1;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        int index = GearSwapperBlock.getSlot(world, data.getPos(), data.getSideHit(), data.getHitVec());
        if (index == -1) {
            probeInfo.text("Right-click to access GUI");
        } else {
            probeInfo.text(TextFormatting.YELLOW + "Sneak-left-click:" + TextFormatting.WHITE + " store current setup in slot");
            probeInfo.text(TextFormatting.YELLOW + "Right-click:" + TextFormatting.WHITE + " restore current setup from slot");
        }
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        RayTraceResult mouseOver = accessor.getMOP();
        int index = GearSwapperBlock.getSlot(mouseOver, accessor.getWorld());
        if (index == -1) {
            currenttip.add("Right-click to access GUI");
        } else {
            currenttip.add("Sneak-left-click: store current setup in slot");
            currenttip.add("Right-click: restore current setup from slot");
        }
        return currenttip;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult mouseOver;
        int index;
        if (world.field_72995_K && player.func_70093_af() && (index = GearSwapperBlock.getSlot(mouseOver = Minecraft.func_71410_x().field_71476_x, world)) >= 0) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRememberSetup(pos, index));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float sx, float sy, float sz) {
        if (!world.field_72995_K) {
            EnumFacing k = GearSwapperBlock.getOrientation((IBlockAccess)world, pos);
            if (side == k) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof GearSwapperTE) {
                    GearSwapperTE gearSwapperTE = (GearSwapperTE)tileEntity;
                    int index = GearSwapperBlock.calculateHitIndex(sx, sy, sz, k);
                    if (index == -1) {
                        player.openGui((Object)GearSwap.instance, GearSwap.GUI_GEARSWAP, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        return true;
                    }
                    gearSwapperTE.restoreSetup(index, player);
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Restored hotbar and armor"));
                }
            } else {
                player.openGui((Object)GearSwap.instance, GearSwap.GUI_GEARSWAP, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    private static int calculateHitIndex(float sx, float sy, float sz, EnumFacing k) {
        int index = -1;
        switch (k) {
            case DOWN: {
                if ((double)sz < 0.13) {
                    return -1;
                }
                index = ((double)sx > 0.5 ? 1 : 0) + ((double)sz < 0.54 ? 2 : 0);
                break;
            }
            case UP: {
                if ((double)sz > 0.87) {
                    return -1;
                }
                index = ((double)sx > 0.5 ? 1 : 0) + ((double)sz > 0.54 ? 2 : 0);
                break;
            }
            case NORTH: {
                if ((double)sy < 0.13) {
                    return -1;
                }
                index = ((double)sx < 0.5 ? 1 : 0) + ((double)sy < 0.54 ? 2 : 0);
                break;
            }
            case SOUTH: {
                if ((double)sy < 0.13) {
                    return -1;
                }
                index = ((double)sx > 0.5 ? 1 : 0) + ((double)sy < 0.54 ? 2 : 0);
                break;
            }
            case WEST: {
                if ((double)sy < 0.13) {
                    return -1;
                }
                index = ((double)sz > 0.5 ? 1 : 0) + ((double)sy < 0.54 ? 2 : 0);
                break;
            }
            case EAST: {
                if ((double)sy < 0.13) {
                    return -1;
                }
                index = ((double)sz < 0.5 ? 1 : 0) + ((double)sy < 0.54 ? 2 : 0);
            }
        }
        return index;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        TileEntity te;
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)GearSwapperBlock.getFacingFromEntity(pos, entityLivingBase)), 2);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (te = world.func_175625_s(pos)) instanceof GearSwapperTE) {
            ((GearSwapperTE)te).readRestorableFromNBT(tagCompound);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof GearSwapperTE) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((GearSwapperTE)tileEntity).writeRestorableToNBT(tagCompound);
            stack.func_77982_d(tagCompound);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            result.add(stack);
            return result;
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    private static EnumFacing getOrientation(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public static EnumFacing getFacingFromEntity(BlockPos clickedBlock, EntityLivingBase entityIn) {
        if (MathHelper.func_76135_e((float)((float)entityIn.field_70165_t - (float)clickedBlock.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entityIn.field_70161_v - (float)clickedBlock.func_177952_p())) < 2.0f) {
            double d0 = entityIn.field_70163_u + (double)entityIn.func_70047_e();
            if (d0 - (double)clickedBlock.func_177956_o() > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)clickedBlock.func_177956_o() - d0 > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return entityIn.func_174811_aO().func_176734_d();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)GearSwapperBlock.getFacing(meta));
    }

    public static EnumFacing getFacing(int meta) {
        int i = meta & 7;
        return i > 5 ? null : EnumFacing.func_82600_a((int)i);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

