/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import mekanism.api.Coord4D;
import mekanism.api.IAlloyInteraction;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.multipart.MultipartTransmitter;
import mekanism.common.multipart.PartSidedPipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class PartTransmitter<A, N extends DynamicNetwork<A, N>>
extends PartSidedPipe
implements IAlloyInteraction {
    public MultipartTransmitter<A, N> transmitterDelegate = new MultipartTransmitter(this);
    public boolean unloaded = true;
    public boolean dataRequest = false;

    public MultipartTransmitter<A, N> getTransmitter() {
        return this.transmitterDelegate;
    }

    public abstract N createNewNetwork();

    public abstract N createNetworkByMerging(Collection<N> var1);

    @Override
    public void onWorldJoin() {
        if (!this.getWorld().field_72995_K) {
            TransmitterNetworkRegistry.registerOrphanTransmitter(this.getTransmitter());
        }
        this.unloaded = false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.getWorld().field_72995_K && !this.dataRequest) {
            this.dataRequest = true;
            MinecraftForge.EVENT_BUS.post((Event)new DynamicNetwork.NetworkClientRequest(this.getWorld().func_175625_s(this.getPos())));
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().field_72995_K) {
            this.getTransmitter().takeShare();
        }
        super.onUnloaded();
    }

    @Override
    public void onWorldSeparate() {
        this.unloaded = true;
        if (!this.getWorld().field_72995_K) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        } else {
            this.getTransmitter().setTransmitterNetwork(null);
        }
    }

    @Override
    public void markDirtyTransmitters() {
        super.markDirtyTransmitters();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    @Override
    public void markDirtyAcceptor(EnumFacing side) {
        super.markDirtyAcceptor(side);
        if (this.getTransmitter().hasTransmitterNetwork()) {
            ((DynamicNetwork)this.getTransmitter().getTransmitterNetwork()).acceptorChanged(this.getTransmitter(), side);
        }
    }

    public abstract A getCachedAcceptor(EnumFacing var1);

    protected TileEntity getCachedTile(EnumFacing side) {
        PartSidedPipe.ConnectionType type = this.connectionTypes[side.ordinal()];
        if (type == PartSidedPipe.ConnectionType.PULL || type == PartSidedPipe.ConnectionType.NONE) {
            return null;
        }
        return PartTransmitter.connectionMapContainsSide(this.currentAcceptorConnections, side) ? this.cachedAcceptors[side.ordinal()] : null;
    }

    @Override
    public void onAlloyInteraction(EntityPlayer player, EnumHand hand, ItemStack stack, int tierOrdinal) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            PartTransmitter t;
            Object iter;
            int upgraded = 0;
            Object[] array = ((LinkedHashSet)((DynamicNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.clone()).toArray();
            Arrays.sort(array, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof IGridTransmitter && o2 instanceof IGridTransmitter) {
                        Coord4D thisCoord = new Coord4D(PartTransmitter.this.getPos(), PartTransmitter.this.getWorld());
                        Coord4D o1Coord = ((IGridTransmitter)o1).coord();
                        Coord4D o2Coord = ((IGridTransmitter)o2).coord();
                        return o1Coord.distanceTo(thisCoord) > o2Coord.distanceTo(thisCoord) ? 1 : (o1Coord.distanceTo(thisCoord) < o2Coord.distanceTo(thisCoord) ? -1 : 0);
                    }
                    return 0;
                }
            });
            Object[] objectArray = array;
            int n = objectArray.length;
            for (int i = 0; !(i >= n || (iter = objectArray[i]) instanceof MultipartTransmitter && (t = ((MultipartTransmitter)iter).containingPart).upgrade(tierOrdinal) && ++upgraded == 8); ++i) {
            }
            if (upgraded > 0 && !player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
                if (stack.field_77994_a == 0) {
                    player.func_184611_a(hand, null);
                }
            }
        }
    }

    public boolean upgrade(int tierOrdinal) {
        return false;
    }

    public abstract int getCapacity();

    public abstract Object getBuffer();

    public abstract void takeShare();

    public abstract void updateShare();

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GRID_TRANSMITTER_CAPABILITY || capability == Capabilities.ALLOY_INTERACTION_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GRID_TRANSMITTER_CAPABILITY) {
            return (T)this.getTransmitter();
        }
        if (capability == Capabilities.ALLOY_INTERACTION_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }
}

