/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChemicalOxidizer
extends TileEntityNoisyElectricBlock
implements ITubeConnection,
IRedstoneControl,
IUpgradeTile,
ISustainedData,
ITankManager,
ISecurityTile {
    public GasTank gasTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public int updateDelay;
    public int gasOutput = 256;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public int operatingTicks = 0;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired = this.BASE_TICKS_REQUIRED = 100;
    public final double BASE_ENERGY_USAGE;
    public double energyUsage = this.BASE_ENERGY_USAGE = MekanismConfig.usage.rotaryCondensentratorUsage;
    public OxidationRecipe cachedRecipe;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 3);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityChemicalOxidizer() {
        super("machine.oxidizer", "ChemicalOxidizer", BlockStateMachine.MachineType.CHEMICAL_OXIDIZER.baseEnergy);
        this.inventory = new ItemStack[4];
        this.upgradeComponent.setSupported(Upgrade.MUFFLING);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            OxidationRecipe recipe;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(1, this);
            if (this.inventory[2] != null && this.gasTank.getGas() != null) {
                this.gasTank.draw(GasTransmission.addGas(this.inventory[2], this.gasTank.getGas()), true);
            }
            if (this.canOperate(recipe = this.getRecipe()) && this.getEnergy() >= this.energyUsage && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.energyUsage);
                if (this.operatingTicks < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                    this.func_70296_d();
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
            if (this.gasTank.getGas() != null) {
                GasStack toSend = new GasStack(this.gasTank.getGas().getGas(), Math.min(this.gasTank.getStored(), this.gasOutput));
                TileEntity tileEntity = Coord4D.get(this).offset(MekanismUtils.getRight(this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getRight(this.facing).func_176734_d(), this.gasTank.getGas().getGas())) {
                    this.gasTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getRight(this.facing).func_176734_d(), toSend, true), true);
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.getOxidizerRecipe(new ItemStackInput(itemstack)) != null;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 2) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return new int[]{0};
        }
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return new int[]{1};
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return new int[]{2};
        }
        return InventoryUtils.EMPTY;
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)this.ticksRequired;
    }

    public OxidationRecipe getRecipe() {
        ItemStackInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ItemStackInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getOxidizerRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public ItemStackInput getInput() {
        return new ItemStackInput(this.inventory[0]);
    }

    public boolean canOperate(OxidationRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inventory, this.gasTank);
    }

    public void operate(OxidationRecipe recipe) {
        recipe.operate(this.inventory, this.gasTank);
        this.func_70296_d();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.operatingTicks = dataStream.readInt();
            if (dataStream.readBoolean()) {
                this.gasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.gasTank.setGas(null);
            }
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        data.add(this.operatingTicks);
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.TUBE_CONNECTION_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.TUBE_CONNECTION_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.gasTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "gasTank", this.gasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.gasTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "gasTank")));
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
            }
            case ENERGY: {
                this.energyUsage = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_USAGE);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
            }
        }
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.gasTank};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

