/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import yalter.mousetweaks.Config;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.Main;
import yalter.mousetweaks.ReflectionCache;

public class Reflection {
    public static ReflectionCache guiContainerClass;
    public static ReflectionCache minecraft;
    private static Obfuscation obfuscation;
    private static boolean checkObfuscation;

    public static boolean reflectGuiContainer() {
        guiContainerClass = new ReflectionCache();
        guiContainerClass.storeClass("GuiContainer", bgl.class);
        Method isMouseOverSlot = Reflection.getMethod(bgl.class, Reflection.getObfuscatedName("isMouseOverSlot", "func_146981_a", "a"), acc.class, Integer.TYPE, Integer.TYPE);
        if (isMouseOverSlot == null) {
            Logger.Log("Failed to get isMouseOverSlot method, quitting.");
            return false;
        }
        guiContainerClass.storeMethod("func_146981_a", isMouseOverSlot);
        Field field = Reflection.getField(bgl.class, Reflection.getObfuscatedName("ignoreMouseUp", "field_146995_H", "H"));
        if (field == null) {
            Logger.Log("Failed to retrieve the E field, disabling RMBTweak.");
            Main.disableRMBTweak = true;
        } else {
            guiContainerClass.storeField("field_146995_H", field);
            field = Reflection.getField(bgl.class, Reflection.getObfuscatedName("dragSplitting", "field_147007_t", "t"));
            if (field == null) {
                Logger.Log("Failed to retreive the q field, disabling RMBTweak.");
                Main.disableRMBTweak = true;
            } else {
                guiContainerClass.storeField("field_147007_t", field);
            }
        }
        return true;
    }

    public static boolean is(Object object, String name) {
        return object.getClass().getSimpleName().equals(name);
    }

    public static boolean doesClassExist(String name) {
        Class clazz = Reflection.getClass(name);
        return clazz != null;
    }

    public static Class getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Field getField(Class clazz, String name) {
        try {
            Field field;
            try {
                field = clazz.getField(name);
            }
            catch (Exception e) {
                field = null;
            }
            if (field == null) {
                field = clazz.getDeclaredField(name);
            }
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            Logger.Log("Could not retrieve field \"" + name + "\" from class \"" + clazz.getName() + "\".");
            if (Config.debug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Field getFinalField(Class clazz, String name) {
        try {
            Field field;
            try {
                field = clazz.getField(name);
            }
            catch (Exception e) {
                field = null;
            }
            if (field == null) {
                field = clazz.getDeclaredField(name);
            }
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.set(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            Logger.Log("Could not retrieve field \"" + name + "\" from class \"" + clazz.getName() + "\"");
            if (Config.debug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class ... args) {
        try {
            Method method;
            try {
                method = clazz.getMethod(name, args);
            }
            catch (Exception e) {
                method = null;
            }
            if (method == null) {
                method = args != null && args.length != 0 ? clazz.getDeclaredMethod(name, args) : clazz.getDeclaredMethod(name, new Class[0]);
            }
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            Logger.Log("Could not retrieve method \"" + name + "\" from class \"" + clazz.getName() + "\"");
            if (Config.debug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static String methodToString(Method method) {
        return Modifier.toString(method.getModifiers()) + " " + (method.getReturnType() != null ? method.getReturnType().getName() : "void") + " " + method.getName();
    }

    public static String getObfuscatedName(String mcpName, String forgeName, String originalName) {
        if (checkObfuscation) {
            Reflection.checkObfuscation();
        }
        if (obfuscation == Obfuscation.MCP) {
            return mcpName;
        }
        if (obfuscation == Obfuscation.FORGE) {
            return forgeName;
        }
        return originalName;
    }

    public static void checkObfuscation() {
        checkObfuscation = false;
        Logger.Log("Obfuscation check, please ignore the following errors (if they come up).");
        obfuscation = Reflection.getField(bgl.class, "ignoreMouseUp") != null ? Obfuscation.MCP : (Reflection.getField(bgl.class, "field_146995_H") != null ? Obfuscation.FORGE : Obfuscation.VANILLA);
        Logger.Log("Obfuscation check completed.");
    }

    static {
        checkObfuscation = true;
    }

    public static enum Obfuscation {
        MCP,
        FORGE,
        VANILLA;

    }
}

