/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialWires.blocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.HashMap;
import java.util.HashSet;
import malte0811.industrialWires.IIC2Connector;
import malte0811.industrialWires.blocks.TileEntityIC2ConnectorGold;
import malte0811.industrialWires.blocks.TileEntityIC2ConnectorHV;
import malte0811.industrialWires.wires.IC2Wiretype;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityIC2ConnectorTin
extends TileEntityImmersiveConnectable
implements IEnergySource,
IEnergySink,
IEBlockInterfaces.IDirectionalTile,
ITickable,
IIC2Connector,
IEBlockInterfaces.IBlockBounds {
    EnumFacing f = EnumFacing.NORTH;
    boolean relay;
    boolean first = true;
    double inBuffer = 0.0;
    double outBuffer = 0.0;
    double maxStored = IC2Wiretype.IC2_TYPES[0].getTransferRate() / 8;
    int tier = 1;

    public TileEntityIC2ConnectorTin(boolean rel) {
        this.relay = rel;
    }

    public TileEntityIC2ConnectorTin() {
    }

    public void func_73660_a() {
        if (this.first) {
            if (!this.field_145850_b.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            }
            this.first = false;
        }
        if (!this.field_145850_b.field_72995_K && this.inBuffer > 0.1) {
            this.transferPower();
        }
    }

    public void transferPower() {
        HashSet conns = new HashSet(ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(this.field_174879_c, this.field_145850_b));
        HashMap<ImmersiveNetHandler.AbstractConnection, ImmutablePair> maxOutputs = new HashMap<ImmersiveNetHandler.AbstractConnection, ImmutablePair>();
        double sum = 0.0;
        for (ImmersiveNetHandler.AbstractConnection c : conns) {
            double tmp;
            IImmersiveConnectable iic = ApiUtils.toIIC((Object)c.end, (World)this.field_145850_b);
            if (!(iic instanceof IIC2Connector) || !((tmp = this.inBuffer - ((IIC2Connector)iic).insertEnergy(this.inBuffer, true)) > 1.0E-8)) continue;
            maxOutputs.put(c, new ImmutablePair((Object)((IIC2Connector)iic), (Object)tmp));
            sum += tmp;
        }
        if (sum < 1.0E-4) {
            return;
        }
        double oldInBuf = this.inBuffer;
        HashMap transferedPerConn = ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension());
        for (ImmersiveNetHandler.AbstractConnection c : maxOutputs.keySet()) {
            Pair p = (Pair)maxOutputs.get(c);
            double out = oldInBuf * (Double)p.getRight() / sum;
            double loss = this.getAverageLossRate(c);
            double inserted = out - ((IIC2Connector)p.getLeft()).insertEnergy(out - loss, false);
            this.inBuffer -= inserted;
            float intermediaryLoss = 0.0f;
            HashSet<IImmersiveConnectable> passedConnectors = new HashSet<IImmersiveConnectable>();
            double energyAtConn = inserted + loss;
            for (ImmersiveNetHandler.Connection sub : c.subConnections) {
                int transferredPerCon = transferedPerConn.containsKey(sub) ? (Integer)transferedPerConn.get(sub) : 0;
                ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).put(sub, (int)((double)transferredPerCon + (energyAtConn -= sub.cableType.getLossRatio() * (double)sub.length)));
                IImmersiveConnectable subStart = ApiUtils.toIIC((Object)sub.start, (World)this.field_145850_b);
                IImmersiveConnectable subEnd = ApiUtils.toIIC((Object)sub.end, (World)this.field_145850_b);
                if (subStart != null && passedConnectors.add(subStart)) {
                    subStart.onEnergyPassthrough((int)(inserted - inserted * (double)intermediaryLoss));
                }
                if (subEnd == null || !passedConnectors.add(subEnd)) continue;
                subEnd.onEnergyPassthrough((int)(inserted - inserted * (double)intermediaryLoss));
            }
        }
    }

    public double getAverageLossRate(ImmersiveNetHandler.AbstractConnection conn) {
        double f = 0.0;
        for (ImmersiveNetHandler.Connection c : conn.subConnections) {
            f += (double)c.length * c.cableType.getLossRatio();
        }
        return f;
    }

    @Override
    public double insertEnergy(double eu, boolean simulate) {
        double insert = Math.min(this.maxStored - this.outBuffer, eu);
        if (!simulate) {
            this.outBuffer += insert;
        }
        return eu - insert;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        this.first = true;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        this.first = true;
    }

    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        EnumFacing side = this.f.func_176734_d();
        return new Vec3d(0.5 + (double)side.func_82601_c() * 0.0625, 0.5 + (double)side.func_96559_d() * 0.0625, 0.5 + (double)side.func_82599_e() * 0.0625);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.f.func_176734_d();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 - conRadius * (double)side.func_82601_c(), 0.5 - conRadius * (double)side.func_96559_d(), 0.5 - conRadius * (double)side.func_82599_e());
    }

    public boolean canConnect() {
        return true;
    }

    public boolean isEnergyOutput() {
        return !this.relay;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        return (this.limitType == null || this.isRelay() && this.limitType == cableType) && this.canConnect(cableType);
    }

    public boolean canConnect(WireType t) {
        return t == IC2Wiretype.IC2_TYPES[0];
    }

    protected boolean isRelay() {
        return this.relay;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return !this.relay && side == this.f;
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return !this.relay && side == this.f;
    }

    public double getDemandedEnergy() {
        double ret = this.maxStored - this.inBuffer;
        if (ret < 0.1) {
            ret = 0.0;
        }
        return ret;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (this.inBuffer < this.maxStored) {
            this.inBuffer += amount;
            this.func_70296_d();
            return 0.0;
        }
        return amount;
    }

    public double getOfferedEnergy() {
        return this.outBuffer;
    }

    public void drawEnergy(double amount) {
        this.outBuffer -= amount;
        this.func_70296_d();
    }

    public int getSourceTier() {
        return this.tier;
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.f = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.relay = nbt.func_74767_n("relay");
        this.inBuffer = nbt.func_74769_h("inBuffer");
        this.outBuffer = nbt.func_74769_h("outBuffer");
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.f.func_176745_a());
        nbt.func_74757_a("relay", this.relay);
        nbt.func_74780_a("inBuffer", this.inBuffer);
        nbt.func_74780_a("outBuffer", this.outBuffer);
    }

    public EnumFacing getFacing() {
        return this.f;
    }

    public void setFacing(EnumFacing facing) {
        this.f = facing;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    public float[] getBlockBounds() {
        float length = this instanceof TileEntityIC2ConnectorHV ? (this.relay ? 0.875f : 0.75f) : (this instanceof TileEntityIC2ConnectorGold ? 0.5625f : 0.5f);
        float wMin = 0.3125f;
        float wMax = 0.6875f;
        switch (this.f.func_176734_d()) {
            case UP: {
                return new float[]{wMin, 0.0f, wMin, wMax, length, wMax};
            }
            case DOWN: {
                return new float[]{wMin, 1.0f - length, wMin, wMax, 1.0f, wMax};
            }
            case SOUTH: {
                return new float[]{wMin, wMin, 0.0f, wMax, wMax, length};
            }
            case NORTH: {
                return new float[]{wMin, wMin, 1.0f - length, wMax, wMax, 1.0f};
            }
            case EAST: {
                return new float[]{0.0f, wMin, wMin, length, wMax, wMax};
            }
            case WEST: {
                return new float[]{1.0f - length, wMin, wMin, 1.0f, wMax, wMax};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public int hashCode() {
        return this.field_174879_c.hashCode();
    }
}

