/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialWires.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import malte0811.industrialWires.IndustrialWires;
import malte0811.industrialWires.wires.IC2Wiretype;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ItemIC2Coil
extends Item
implements IWireCoil {
    public static final String[] subNames = new String[]{"tin", "copper", "gold", "hv"};

    public ItemIC2Coil() {
        this.func_77655_b("industrialwires.ic2wireCoil");
        this.func_77627_a(true);
        this.func_77637_a(IndustrialWires.creativeTab);
        this.func_77625_d(64);
        ImmersiveEngineering.registerByFullName((IForgeRegistryEntry)this, (String)"industrialwires:ic2WireCoil");
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int i = 0; i < subNames.length; ++i) {
            subItems.add(new ItemStack((Item)this, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + subNames[stack.func_77960_j()];
    }

    public WireType getWireType(ItemStack stack) {
        return IC2Wiretype.IC2_TYPES[stack.func_77960_j()];
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean adv) {
        int[] link;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("linkingPos") && (link = stack.func_77978_p().func_74759_k("linkingPos")) != null && link.length > 3) {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
            WireType wire = this.getWireType(stack);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(wire, target);
            if (!((tileEntity = world.func_175625_s(masterPos)) instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntity).canConnect()) {
                return EnumActionResult.PASS;
            }
            if (!((IImmersiveConnectable)tileEntity).canConnectCable(wire, target)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.wrongCable", new Object[0]));
                return EnumActionResult.FAIL;
            }
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"linkingPos")) {
                ItemNBTHelper.setIntArray((ItemStack)stack, (String)"linkingPos", (int[])new int[]{world.field_73011_w.getDimension(), masterPos.func_177958_n(), masterPos.func_177956_o(), masterPos.func_177952_p()});
                target.writeToNBT(stack.func_77978_p());
            } else {
                WireType type = this.getWireType(stack);
                int[] array = ItemNBTHelper.getIntArray((ItemStack)stack, (String)"linkingPos");
                BlockPos linkPos = new BlockPos(array[1], array[2], array[3]);
                TileEntity tileEntityLinkingPos = world.func_175625_s(linkPos);
                int distanceSq = (int)Math.ceil(linkPos.func_177951_i((Vec3i)masterPos));
                if (array[0] != world.field_73011_w.getDimension()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.wrongDimension", new Object[0]));
                } else if (linkPos.equals((Object)masterPos)) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.sameConnection", new Object[0]));
                } else if (distanceSq > type.getMaxLength() * type.getMaxLength()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.tooFar", new Object[0]));
                } else if (!(tileEntityLinkingPos instanceof IImmersiveConnectable)) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.invalidPoint", new Object[0]));
                } else {
                    IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                    IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                    boolean connectionExists = false;
                    Set outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, Utils.toCC((Object)nodeHere));
                    if (outputs != null) {
                        for (ImmersiveNetHandler.Connection con : outputs) {
                            if (!con.end.equals((Object)Utils.toCC((Object)nodeLink))) continue;
                            connectionExists = true;
                        }
                    }
                    if (connectionExists) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.connectionExists", new Object[0]));
                    } else {
                        boolean canSee;
                        Vec3d rtOff0 = nodeHere.getRaytraceOffset(nodeLink).func_72441_c((double)masterPos.func_177958_n(), (double)masterPos.func_177956_o(), (double)masterPos.func_177952_p());
                        Vec3d rtOff1 = nodeLink.getRaytraceOffset(nodeHere).func_72441_c((double)linkPos.func_177958_n(), (double)linkPos.func_177956_o(), (double)linkPos.func_177952_p());
                        HashSet ignore = new HashSet();
                        ignore.addAll(nodeHere.getIgnored(nodeLink));
                        ignore.addAll(nodeLink.getIgnored(nodeHere));
                        boolean bl = canSee = Utils.rayTraceForFirst((Vec3d)rtOff0, (Vec3d)rtOff1, (World)world, ignore) == null;
                        if (canSee) {
                            TargetingInfo targetLink = TargetingInfo.readFromNBT((NBTTagCompound)stack.func_77978_p());
                            ImmersiveNetHandler.INSTANCE.addConnection(world, Utils.toCC((Object)nodeHere), Utils.toCC((Object)nodeLink), (int)Math.sqrt(distanceSq), type);
                            nodeHere.connectCable(type, target, nodeLink);
                            nodeLink.connectCable(type, targetLink, nodeHere);
                            IESaveData.setDirty((int)world.field_73011_w.getDimension());
                            player.func_71029_a((StatBase)IEAchievements.connectWire);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                            ((TileEntity)nodeHere).func_70296_d();
                            world.func_175641_c(masterPos, ((TileEntity)nodeHere).func_145838_q(), -1, 0);
                            IBlockState state = world.func_180495_p(masterPos);
                            world.func_184138_a(masterPos, state, state, 3);
                            ((TileEntity)nodeLink).func_70296_d();
                            world.func_175641_c(linkPos, ((TileEntity)nodeLink).func_145838_q(), -1, 0);
                            state = world.func_180495_p(linkPos);
                            world.func_184138_a(linkPos, state, state, 3);
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.cantSee", new Object[0]));
                        }
                    }
                }
                ItemNBTHelper.remove((ItemStack)stack, (String)"linkingPos");
                ItemNBTHelper.remove((ItemStack)stack, (String)"side");
                ItemNBTHelper.remove((ItemStack)stack, (String)"hitX");
                ItemNBTHelper.remove((ItemStack)stack, (String)"hitY");
                ItemNBTHelper.remove((ItemStack)stack, (String)"hitZ");
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }
}

