/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component;

import com.google.common.eventbus.Subscribe;
import java.util.List;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.decoration.UITooltip;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.event.component.StateChangeEvent;
import net.malisis.core.inventory.InventoryEvent;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class UISlot
extends UIComponent<UISlot> {
    protected GuiIconProvider iconLeftProvider;
    protected GuiIconProvider iconTopProvider;
    public static boolean buttonRelased = true;
    protected MalisisSlot slot;
    protected UITooltip defaultTooltip;

    public UISlot(MalisisGui gui, MalisisSlot slot) {
        super(gui);
        this.slot = slot;
        this.width = 18;
        this.height = 18;
        slot.register(this);
        this.shape = new SimpleGuiShape();
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getIcon(209, 30, 18, 18));
        this.iconLeftProvider = new GuiIconProvider(gui.getGuiTexture().getIcon(209, 30, 1, 18));
        this.iconTopProvider = new GuiIconProvider(gui.getGuiTexture().getIcon(209, 30, 18, 1));
    }

    public UISlot(MalisisGui gui) {
        this(gui, null);
    }

    @Override
    public UISlot setTooltip(UITooltip tooltip) {
        this.defaultTooltip = tooltip;
        if (tooltip == null) {
            tooltip = this.defaultTooltip;
        }
        return this;
    }

    protected void updateTooltip() {
        if (this.slot.getItemStack() == null) {
            this.tooltip = this.defaultTooltip;
            return;
        }
        List lines = this.slot.getItemStack().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        lines.set(0, this.slot.getItemStack().func_77953_t().field_77937_e + (String)lines.get(0));
        for (int i = 1; i < lines.size(); ++i) {
            lines.set(i, TextFormatting.GRAY + (String)lines.get(i));
        }
        this.tooltip = new UITooltip(this.getGui()).setText(lines);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.shape.resetState();
        this.shape.setSize(18, 18);
        renderer.drawShape(this.shape, this.rp);
        renderer.next();
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        MalisisInventoryContainer container = MalisisGui.currentGui().getInventoryContainer();
        if (container == null) {
            return;
        }
        ItemStack itemStack = this.slot.getItemStack() != null ? this.slot.getItemStack().func_77946_l() : null;
        ItemStack draggedItemStack = this.slot.getDraggedItemStack();
        TextFormatting format = null;
        if (itemStack == null) {
            itemStack = draggedItemStack;
        } else if (draggedItemStack != null) {
            itemStack.field_77994_a += draggedItemStack.field_77994_a;
            if (itemStack.field_77994_a == itemStack.func_77976_d()) {
                format = TextFormatting.YELLOW;
            }
        }
        if (itemStack != null) {
            renderer.drawItemStack(itemStack, 1, 1, new Style().func_150238_a(format));
        }
        if (this.hovered || draggedItemStack != null) {
            renderer.disableTextures();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            renderer.next();
            renderer.drawRectangle(1, 1, 100, 16, 16, 0xFFFFFF, 80);
            renderer.next();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            renderer.enableTextures();
        }
    }

    @Override
    public boolean onClick(int x, int y) {
        return super.onClick(x, y);
    }

    @Override
    public boolean onRightClick(int x, int y) {
        return super.onRightClick(x, y);
    }

    @Override
    public boolean onButtonPress(int x, int y, MouseButton button) {
        MalisisInventoryContainer.ActionType action = null;
        MalisisInventoryContainer container = MalisisGui.currentGui().getInventoryContainer();
        if (container.getPickedItemStack() != null) {
            return super.onButtonPress(x, y, button);
        }
        if (button.getCode() == Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151463_i() + 100) {
            action = MalisisInventoryContainer.ActionType.PICKBLOCK;
        }
        if (button == MouseButton.LEFT) {
            MalisisInventoryContainer.ActionType actionType = action = GuiScreen.func_146272_n() ? MalisisInventoryContainer.ActionType.SHIFT_LEFT_CLICK : MalisisInventoryContainer.ActionType.LEFT_CLICK;
        }
        if (button == MouseButton.RIGHT) {
            action = GuiScreen.func_146272_n() ? MalisisInventoryContainer.ActionType.SHIFT_RIGHT_CLICK : MalisisInventoryContainer.ActionType.RIGHT_CLICK;
        }
        buttonRelased = false;
        MalisisGui.sendAction(action, this.slot, button.getCode());
        return true;
    }

    @Override
    public boolean onButtonRelease(int x, int y, MouseButton button) {
        MalisisInventoryContainer.ActionType action = null;
        MalisisInventoryContainer container = MalisisGui.currentGui().getInventoryContainer();
        if (container.getPickedItemStack() == null || !buttonRelased) {
            buttonRelased = true;
            return super.onButtonPress(x, y, button);
        }
        if (button == MouseButton.LEFT) {
            MalisisInventoryContainer.ActionType actionType = action = GuiScreen.func_146272_n() ? MalisisInventoryContainer.ActionType.SHIFT_LEFT_CLICK : MalisisInventoryContainer.ActionType.LEFT_CLICK;
        }
        if (button == MouseButton.RIGHT) {
            action = GuiScreen.func_146272_n() ? MalisisInventoryContainer.ActionType.SHIFT_RIGHT_CLICK : MalisisInventoryContainer.ActionType.RIGHT_CLICK;
        }
        MalisisGui.sendAction(action, this.slot, button.getCode());
        return true;
    }

    @Override
    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        MalisisInventoryContainer container = MalisisGui.currentGui().getInventoryContainer();
        MalisisInventoryContainer.ActionType action = null;
        if (container.getPickedItemStack() != null && !container.isDraggingItemStack() && buttonRelased) {
            if (button == MouseButton.LEFT) {
                MalisisInventoryContainer.ActionType actionType = action = GuiScreen.func_146271_m() ? MalisisInventoryContainer.ActionType.DRAG_START_PICKUP : MalisisInventoryContainer.ActionType.DRAG_START_LEFT_CLICK;
            }
            if (button == MouseButton.RIGHT) {
                action = MalisisInventoryContainer.ActionType.DRAG_START_RIGHT_CLICK;
            }
        }
        MalisisGui.sendAction(action, this.slot, button.getCode());
        return true;
    }

    @Override
    public boolean onDoubleClick(int x, int y, MouseButton button) {
        if (button != MouseButton.LEFT) {
            return super.onDoubleClick(x, y, button);
        }
        MalisisInventoryContainer.ActionType action = GuiScreen.func_146272_n() ? MalisisInventoryContainer.ActionType.DOUBLE_SHIFT_LEFT_CLICK : MalisisInventoryContainer.ActionType.DOUBLE_LEFT_CLICK;
        MalisisGui.sendAction(action, this.slot, button.getCode());
        buttonRelased = false;
        return true;
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (!this.isHovered() || MalisisGui.isGuiCloseKey(keyCode)) {
            return super.onKeyTyped(keyChar, keyCode);
        }
        MalisisInventoryContainer.ActionType action = null;
        int code = keyCode;
        if (keyCode == Minecraft.func_71410_x().field_71474_y.field_74316_C.func_151463_i()) {
            MalisisInventoryContainer.ActionType actionType = action = GuiScreen.func_146272_n() ? MalisisInventoryContainer.ActionType.DROP_SLOT_STACK : MalisisInventoryContainer.ActionType.DROP_SLOT_ONE;
        }
        if (keyCode == Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151463_i()) {
            action = MalisisInventoryContainer.ActionType.PICKBLOCK;
        }
        if (keyCode >= 2 && keyCode <= 10) {
            action = MalisisInventoryContainer.ActionType.HOTBAR;
            code -= 2;
        }
        MalisisGui.sendAction(action, this.slot, code);
        return true;
    }

    @Subscribe
    public void onSlotChanged(InventoryEvent.SlotChanged event) {
        if (event.getSlot() != this.slot) {
            return;
        }
        this.updateTooltip();
    }

    @Subscribe
    public void onHovered(StateChangeEvent.HoveredStateChange<UISlot> event) {
        this.updateTooltip();
        if (event.getState() && MalisisGui.currentGui().getInventoryContainer().isDraggingItemStack()) {
            MalisisGui.sendAction(MalisisInventoryContainer.ActionType.DRAG_ADD_SLOT, this.slot, 0);
        }
    }
}

