/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.malisis.core.MalisisRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public interface IItemRenderer {
    public boolean renderItem(ItemStack var1, float var2);

    public void setTransformType(ItemCameraTransforms.TransformType var1);

    public Matrix4f getTransform(Item var1, ItemCameraTransforms.TransformType var2);

    public boolean isGui3d();

    public static class DummyModel
    implements IPerspectiveAwareModel {
        private Item item;
        private ModelResourceLocation mrl;

        public DummyModel(Item item, ResourceLocation rl) {
            this.item = item;
            this.mrl = new ModelResourceLocation(rl, "inventory");
        }

        public ModelResourceLocation getResourceLocation() {
            return this.mrl;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transformType) {
            IItemRenderer itemRenderer = MalisisRegistry.getItemRenderer(this.item);
            if (itemRenderer == null) {
                return Pair.of((Object)this, null);
            }
            itemRenderer.setTransformType(transformType);
            return Pair.of((Object)this, (Object)itemRenderer.getTransform(this.item, transformType));
        }

        public boolean func_177556_c() {
            IItemRenderer itemRenderer = MalisisRegistry.getItemRenderer(this.item);
            return itemRenderer != null && itemRenderer.isGui3d();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return ImmutableList.of();
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public String toString() {
            return this.item.func_77658_a() + "[" + this.mrl + "]";
        }
    }
}

