/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import java.util.EnumMap;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;

public class PropertyEnumIconProvider<T extends Enum<T>>
implements IBlockIconProvider.IStatesIconProvider {
    private PropertyEnum<T> property;
    private Icon defaultIcon;
    private EnumMap<T, Icon> icons;

    public PropertyEnumIconProvider(PropertyEnum<T> property, Class<T> enumClass, String defaultName) {
        this.property = property;
        this.icons = new EnumMap(enumClass);
        this.defaultIcon = new Icon(defaultName);
    }

    public PropertyEnumIconProvider(PropertyEnum<T> property, Class<T> enumClass, Icon defaultIcon) {
        this.property = property;
        this.icons = new EnumMap(enumClass);
        this.defaultIcon = defaultIcon;
    }

    public PropertyEnumIconProvider(PropertyEnum<T> property, Class<T> enumClass) {
        this(property, enumClass, (Icon)null);
    }

    public void setIcon(T enumValue, Icon icon) {
        this.icons.put(enumValue, icon);
    }

    public void setIcon(T enumValue, String iconName) {
        this.icons.put(enumValue, new Icon(iconName));
    }

    @Override
    public Icon getIcon() {
        return this.defaultIcon;
    }

    public Icon getIcon(T value) {
        return this.icons.getOrDefault(value, this.getIcon());
    }

    @Override
    public Icon getIcon(IBlockState state) {
        return state != null ? this.getIcon((Enum)((Object)state.func_177229_b(this.property))) : this.getIcon();
    }
}

