/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class BlockPosUtils {
    public static BlockPos rotate(BlockPos pos, int rotation) {
        int[] cos = new int[]{1, 0, -1, 0};
        int[] sin = new int[]{0, 1, 0, -1};
        int a = -rotation & 3;
        int newX = pos.func_177958_n() * cos[a] - pos.func_177952_p() * sin[a];
        int newZ = pos.func_177958_n() * sin[a] + pos.func_177952_p() * cos[a];
        return new BlockPos(newX, pos.func_177956_o(), newZ);
    }

    public static BlockPos chunkPosition(BlockPos pos) {
        return new BlockPos(pos.func_177958_n() - (pos.func_177958_n() >> 4) * 16, pos.func_177956_o() - (pos.func_177956_o() >> 4) * 16, pos.func_177952_p() - (pos.func_177952_p() >> 4) * 16);
    }

    public static Iterable<BlockPos> getAllInBox(AxisAlignedBB aabb) {
        return BlockPos.func_177980_a((BlockPos)new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), (BlockPos)new BlockPos(Math.ceil(aabb.field_72336_d) - 1.0, Math.ceil(aabb.field_72337_e) - 1.0, Math.ceil(aabb.field_72334_f) - 1.0));
    }

    public static ByteBuf toBytes(BlockPos pos) {
        ByteBuf buf = Unpooled.buffer((int)8);
        buf.writeLong(pos.func_177986_g());
        return buf;
    }

    public static BlockPos fromBytes(ByteBuf buf) {
        return BlockPos.func_177969_a((long)buf.readLong());
    }
}

