/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.clientnotif;

import io.netty.buffer.ByteBuf;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.network.MalisisMessage;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@MalisisMessage
public class NeighborChangedMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public NeighborChangedMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.CLIENT);
    }

    @Override
    public void process(Packet message, MessageContext ctx) {
        World world = IMalisisMessageHandler.getWorld(ctx);
        world.func_180495_p(message.pos).func_189546_a(world, message.pos, message.neighbor);
    }

    public static void send(World world, BlockPos pos, Block neighbor) {
        Packet packet = new Packet(pos, neighbor);
        MalisisCore.network.sendToPlayersWatchingChunk(packet, world.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4));
    }

    public static class Packet
    implements IMessage {
        private BlockPos pos;
        private Block neighbor;

        public Packet() {
        }

        public Packet(BlockPos pos, Block neighbor) {
            this.pos = pos;
            this.neighbor = neighbor;
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.neighbor = Block.func_149729_e((int)buf.readInt());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeLong(this.pos.func_177986_g());
            buf.writeInt(Block.func_149682_b((Block)this.neighbor));
        }
    }
}

