/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.multiblock;

import com.google.common.collect.Lists;
import java.util.List;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.util.multiblock.MultiBlock;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultiBlockComponent
implements IBlockComponent {
    public static PropertyBool ORIGIN = PropertyBool.func_177716_a((String)"origin");
    private MultiBlock multiBlock;
    private IMultiBlockProvider provider;

    public MultiBlockComponent(MultiBlock multiBlock) {
        this.multiBlock = multiBlock;
    }

    public MultiBlockComponent(IMultiBlockProvider provider) {
        this.provider = provider;
    }

    public MultiBlock getMultiBlock() {
        return this.multiBlock;
    }

    public IMultiBlockProvider getProvider() {
        return this.provider;
    }

    public PropertyBool getProperty() {
        return ORIGIN;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(false));
    }

    @Override
    public List<IComponent> getDependencies() {
        return Lists.newArrayList((Object[])new IComponent[]{new DirectionalComponent()});
    }

    @Override
    public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void onBlockPlacedBy(Block block, World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        MultiBlock multiBlock = MultiBlockComponent.getMultiBlock((IBlockAccess)world, pos, state, stack);
        if (multiBlock == null || !multiBlock.isBulkPlace()) {
            return;
        }
        if (multiBlock.canPlaceBlockAt(world, pos, state, false)) {
            multiBlock.placeBlocks(world, pos, state, false);
        } else {
            world.func_175698_g(pos);
        }
    }

    @Override
    public void breakBlock(Block block, World world, BlockPos pos, IBlockState state) {
        MultiBlock multiBlock = MultiBlockComponent.getMultiBlock((IBlockAccess)world, pos, state, null);
        if (multiBlock != null && multiBlock.isBulkBreak()) {
            multiBlock.breakBlocks(world, pos, state);
        }
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return MultiBlockComponent.isOrigin(state) ? 8 : 0;
    }

    public static boolean isOrigin(World world, BlockPos pos) {
        return world != null && pos != null && MultiBlockComponent.isOrigin(world.func_180495_p(pos));
    }

    public static boolean isOrigin(IBlockState state) {
        MultiBlockComponent mbc = IComponent.getComponent(MultiBlockComponent.class, state.func_177230_c());
        if (mbc == null) {
            return false;
        }
        PropertyBool property = mbc.getProperty();
        if (property == null || !state.func_177228_b().containsKey((Object)property)) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)property);
    }

    public static MultiBlock getMultiBlock(IBlockAccess world, BlockPos pos, IBlockState state, ItemStack itemStack) {
        MultiBlockComponent mbc = IComponent.getComponent(MultiBlockComponent.class, state.func_177230_c());
        if (mbc == null) {
            return null;
        }
        MultiBlock multiBlock = mbc.getMultiBlock();
        if (multiBlock != null) {
            return multiBlock;
        }
        IMultiBlockProvider provider = mbc.getProvider();
        return provider != null ? provider.getMultiBlock(world, pos, state, itemStack) : null;
    }

    public static interface IMultiBlockProvider {
        public MultiBlock getMultiBlock(IBlockAccess var1, BlockPos var2, IBlockState var3, ItemStack var4);
    }
}

