/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.raytrace;

import java.util.ArrayList;
import java.util.List;
import net.malisis.core.util.Point;
import net.malisis.core.util.Ray;
import net.malisis.core.util.Vector;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Raytrace {
    protected Point src;
    protected Point dest;
    protected Ray ray;

    public Raytrace(Ray ray) {
        this.src = ray.origin;
        this.ray = ray;
    }

    public Raytrace(Point src, Point dest) {
        this(new Ray(src, new Vector(src, dest)));
        this.dest = dest;
    }

    public Raytrace(Vec3d src, Vec3d dest) {
        this(new Ray(src, dest));
        this.dest = new Point(dest);
    }

    public Vector direction() {
        return this.ray.direction;
    }

    public double distance() {
        return this.ray.direction.length();
    }

    public Pair<EnumFacing, Point> trace(AxisAlignedBB ... aabbs) {
        if (ArrayUtils.isEmpty((Object[])aabbs)) {
            return null;
        }
        ArrayList<Pair<EnumFacing, Point>> points = new ArrayList<Pair<EnumFacing, Point>>();
        double maxDist = this.dest != null ? Point.distanceSquared(this.src, this.dest) : Double.MAX_VALUE;
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            for (Pair<EnumFacing, Point> pair : this.ray.intersect(aabb)) {
                if (!(Point.distanceSquared(this.src, (Point)pair.getRight()) < maxDist)) continue;
                points.add(pair);
            }
        }
        if (points.size() == 0) {
            return null;
        }
        return this.getClosest(points);
    }

    private Pair<EnumFacing, Point> getClosest(List<Pair<EnumFacing, Point>> points) {
        double distance = Double.MAX_VALUE;
        Pair<EnumFacing, Point> ret = null;
        for (Pair<EnumFacing, Point> pair : points) {
            double d = Point.distanceSquared(this.src, (Point)pair.getRight());
            if (!(distance > d)) continue;
            distance = d;
            ret = pair;
        }
        return ret;
    }
}

