/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.replacement;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.util.replacement.ReplacementHandler;
import net.malisis.core.util.replacement.ShapedOreRecipeHandler;
import net.malisis.core.util.replacement.ShapedRecipesHandler;
import net.malisis.core.util.replacement.ShapelessOreRecipeHandler;
import net.malisis.core.util.replacement.ShapelessRecipesHandler;
import net.malisis.core.util.replacement.StatCraftingHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.RegistryDelegate;

public class ReplacementTool {
    private static ReplacementTool instance = new ReplacementTool();
    private HashMap<Block, Block> originalBlocks = new HashMap();
    private HashMap<Item, Item> originalItems = new HashMap();
    private Class<?>[] types = new Class[]{Integer.TYPE, ResourceLocation.class, IForgeRegistryEntry.class};
    private Method addObjectRaw = AsmUtils.changeMethodAccess(FMLControlledNamespacedRegistry.class, "addObjectRaw", this.types);
    private Method setName = AsmUtils.changeMethodAccess(RegistryDelegate.Delegate.class, "setName", ResourceLocation.class);
    private Field underlyingMap = AsmUtils.changeFieldAccess(RegistryNamespaced.class, "underlyingIntegerMap", "field_148759_a");
    private Field objectArray = AsmUtils.changeFieldAccess(IntIdentityHashBiMap.class, "values", "field_186818_b");

    private ReplacementTool() {
        new ShapedOreRecipeHandler();
        new ShapedRecipesHandler();
        new ShapelessRecipesHandler();
        new ShapelessOreRecipeHandler();
        new StatCraftingHandler();
    }

    public static ReplacementTool instance() {
        return instance;
    }

    private void replaceVanilla(int id, String registryName, String fieldName, String srgFieldName, Object replacement, Object vanilla) {
        boolean block = replacement instanceof Block;
        RegistryNamespacedDefaultedByKey registry = block ? Block.field_149771_c : Item.field_150901_e;
        ItemBlock ib = block ? (ItemBlock)Item.func_150898_a((Block)((Block)vanilla)) : null;
        Class clazz = block ? Blocks.class : Items.class;
        ResourceLocation rl = new ResourceLocation("minecraft", registryName);
        try {
            this.setName.invoke((Object)(block ? ((Block)replacement).delegate : ((Item)replacement).delegate), rl);
            this.addObjectRaw.invoke((Object)registry, id, rl, replacement);
            Object[] objArray = (Object[])this.objectArray.get(this.underlyingMap.get(registry));
            for (int i = 0; i < objArray.length; ++i) {
                if (objArray[i] != vanilla) continue;
                objArray[i] = replacement;
            }
            Field f = AsmUtils.changeFieldAccess(clazz, fieldName, srgFieldName);
            f.set(null, replacement);
            if (ib != null) {
                AsmUtils.changeFieldAccess(ItemBlock.class, "block", "field_150939_a").set(ib, replacement);
                GameData.getBlockItemMap().forcePut((Object)((Block)replacement), (Object)ib);
            }
            if (block) {
                this.originalBlocks.put((Block)replacement, (Block)vanilla);
            } else {
                this.originalItems.put((Item)replacement, (Item)vanilla);
            }
            this.replaceIn(CraftingManager.func_77594_a().func_77592_b(), vanilla, replacement);
            this.replaceIn(StatList.field_75940_b, vanilla, replacement);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    protected static void doubleCheck(RegistryNamespaced<ResourceLocation, ?> registry, Object replacement, Object vanilla) {
        for (Object obj : registry) {
            if (obj == vanilla) {
                MalisisCore.log.info("Found vanilla " + vanilla.getClass().getSimpleName() + " ( " + vanilla + ") in registry");
            }
            if (obj != replacement) continue;
            MalisisCore.log.info("Found replacement " + replacement.getClass().getSimpleName() + " ( " + replacement + ") in registry");
        }
    }

    public <T> void replaceIn(List<T> list, Object vanilla, Object replacement) throws ReflectiveOperationException {
        for (T object : list) {
            ReplacementHandler<T> rh = ReplacementHandler.getHandler(object);
            if (rh == null) continue;
            rh.replace(object, vanilla, replacement);
        }
    }

    public static void replaceVanillaBlock(int id, String registryName, String fieldName, String srgFieldName, Block replacement, Block vanilla) {
        ReplacementTool.instance().replaceVanilla(id, registryName, fieldName, srgFieldName, replacement, vanilla);
    }

    public static void replaceVanillaItem(int id, String registryName, String fieldName, String srgFieldName, Item replacement, Item vanilla) {
        ReplacementTool.instance().replaceVanilla(id, registryName, fieldName, srgFieldName, replacement, vanilla);
    }

    public static Block orignalBlock(Block block) {
        return ReplacementTool.instance.originalBlocks.get(block);
    }

    public static Item originalItem(Item item) {
        return ReplacementTool.instance.originalItems.get(item);
    }
}

