/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.api;

import gnu.trove.map.hash.THashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CalculatorAPI {
    private static final List<ResourceLocation> multiplierBlacklist = new ArrayList<ResourceLocation>();
    private static final List<String> multiplierModBlacklist = new ArrayList<String>();
    private static final Map<String, List<Object[]>> recipes = new THashMap();
    public static final String VERSION = "1.9.4 - 1.0";
    public static final String MODID = "Calculator";
    public static final String NAME = "CalculatorAPI";

    private CalculatorAPI() {
    }

    public static List<Object[]> getRecipes(String recipeID) {
        List<Object[]> recipe = recipes.get(recipeID);
        return recipe;
    }

    public static void registerRecipe(String recipeID, Object ... obj) {
        if (recipes.get(recipeID) == null) {
            recipes.put(recipeID, new ArrayList());
        }
        recipes.get(recipeID).add(obj);
    }

    public static List<ResourceLocation> getItemBlackList() {
        return multiplierBlacklist;
    }

    public static List<String> getModBlackList() {
        return multiplierModBlacklist;
    }

    public static void addItemStackToBlackList(ItemStack stack) {
        multiplierBlacklist.add(stack.func_77973_b().getRegistryName());
    }

    public static void addModToBlackList(String string) {
        multiplierModBlacklist.add(string);
    }

    public static void registerCalculatorRecipe(Object ... objects) {
        try {
            Class<?> recipeClass = Class.forName("sonar.calculator.mod.common.recipes.RecipeRegistry");
            Method method = recipeClass.getMethod("registerCalculatorRecipe", Object[].class);
            method.invoke(null, objects);
        }
        catch (Exception exception) {
            System.err.println("Calculator API: Invalid Calculator Recipe  " + exception.getMessage());
        }
    }

    public static void registerScientificRecipe(Object ... objects) {
        try {
            Class<?> recipeClass = Class.forName("sonar.calculator.mod.common.recipes.RecipeRegistry");
            Method method = recipeClass.getMethod("registerScientificRecipe", Object[].class);
            method.invoke(null, objects);
        }
        catch (Exception exception) {
            System.err.println("Calculator API: Invalid Scientific Recipe  " + exception.getMessage());
        }
    }

    public static void registerAtomicRecipe(Object ... objects) {
        try {
            Class<?> recipeClass = Class.forName("sonar.calculator.mod.common.recipes.RecipeRegistry");
            Method method = recipeClass.getMethod("registerAtomicRecipe", Object[].class);
            method.invoke(null, objects);
        }
        catch (Exception exception) {
            System.err.println("Calculator API: Invalid Atomic Recipe  " + exception.getMessage());
        }
    }

    public static void registerFlawlessRecipe(Object ... objects) {
        try {
            Class<?> recipeClass = Class.forName("sonar.calculator.mod.common.recipes.RecipeRegistry");
            Method method = recipeClass.getMethod("registerFlawlessRecipe", Object[].class);
            method.invoke(null, objects);
        }
        catch (Exception exception) {
            System.err.println("Calculator API: Invalid Atomic Recipe  " + exception.getMessage());
        }
    }
}

